/*
 * Decompiled with CFR 0.152.
 */
package org.ifinalframework.json;

import java.util.Objects;
import org.ifinalframework.json.JsonService;
import org.ifinalframework.json.jackson.JacksonJsonService;

public final class JsonRegistry {
    private static final JsonRegistry instance = new JsonRegistry();
    private JsonService defaultJsonService = new JacksonJsonService();
    private JsonService jsonService;

    private JsonRegistry() {
    }

    public static JsonRegistry getInstance() {
        return instance;
    }

    public JsonService getJsonService() {
        if (Objects.nonNull(this.jsonService)) {
            return this.jsonService;
        }
        return this.defaultJsonService;
    }

    public void setDefaultJsonService(JsonService jsonService) {
        this.defaultJsonService = Objects.requireNonNull(jsonService);
    }

    public synchronized void register(JsonService jsonService) {
        this.jsonService = Objects.requireNonNull(jsonService, "json service can not be null");
    }
}

