/*
 * Decompiled with CFR 0.152.
 */
package org.ifinalframework.json.jackson;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Objects;
import lombok.Generated;
import org.ifinalframework.json.JsonException;
import org.ifinalframework.json.JsonService;
import org.ifinalframework.json.jackson.ObjectMapperFactory;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class JacksonJsonService
implements JsonService {
    private ObjectMapper objectMapper;

    public JacksonJsonService(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public JacksonJsonService() {
        this(new ObjectMapperFactory().create());
    }

    @Override
    public String toJson(@Nullable Object object, @Nullable Class<?> view) {
        try {
            if (Objects.isNull(view)) {
                return this.objectMapper.writeValueAsString(object);
            }
            return this.objectMapper.writerWithView(view).writeValueAsString(object);
        }
        catch (Exception e) {
            throw new JsonException(e);
        }
    }

    @Override
    public <T> T toObject(@Nullable String json, @NonNull Class<T> classOfT, @Nullable Class<?> view) {
        try {
            if (Objects.isNull(json)) {
                return null;
            }
            if (Objects.isNull(view)) {
                return (T)this.objectMapper.readValue(json, classOfT);
            }
            return (T)this.objectMapper.readerWithView(view).readValue(json, classOfT);
        }
        catch (Exception e) {
            throw new JsonException(e);
        }
    }

    @Override
    public <T> T toObject(@Nullable String json, @NonNull Type typeOfT, @Nullable Class<?> view) {
        try {
            if (Objects.isNull(json)) {
                return null;
            }
            if (Objects.isNull(view)) {
                return (T)this.objectMapper.readValue(json, this.objectMapper.getTypeFactory().constructType(typeOfT));
            }
            return (T)this.objectMapper.readerWithView(view).forType(this.objectMapper.getTypeFactory().constructType(typeOfT)).readValue(json);
        }
        catch (Exception e) {
            throw new JsonException(e);
        }
    }

    @Override
    public <E, T extends Collection<E>> T toCollection(@Nullable String json, @NonNull Class<T> collectionClass, @NonNull Class<E> elementClass, @Nullable Class<?> view) {
        try {
            if (Objects.isNull(json)) {
                return null;
            }
            if (Objects.isNull(view)) {
                return (T)((Collection)this.objectMapper.readValue(json, (JavaType)this.objectMapper.getTypeFactory().constructCollectionType(collectionClass, elementClass)));
            }
            return (T)((Collection)this.objectMapper.readerWithView(view).forType((JavaType)this.objectMapper.getTypeFactory().constructCollectionType(collectionClass, elementClass)).readValue(json));
        }
        catch (Exception e) {
            throw new JsonException(e);
        }
    }

    @Generated
    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

