/*
 * Decompiled with CFR 0.152.
 */
package org.ifinalframework.json.jackson.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.Deserializers;
import com.fasterxml.jackson.databind.module.SimpleDeserializers;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.ifinalframework.auto.service.annotation.AutoService;
import org.ifinalframework.core.IEnum;

@AutoService(value=Deserializers.class)
public class IEnumDeserializers
extends SimpleDeserializers {
    public JsonDeserializer<?> findEnumDeserializer(Class<?> type, DeserializationConfig config, BeanDescription beanDesc) throws JsonMappingException {
        if (IEnum.class.isAssignableFrom(type)) {
            return new EnumDeserializer(type);
        }
        return super.findEnumDeserializer(type, config, beanDesc);
    }

    private static class EnumDeserializer<T extends IEnum<?>>
    extends JsonDeserializer<T> {
        private final Class<T> enumType;
        private final Map<String, T> cache;

        EnumDeserializer(Class<T> enumType) {
            this.enumType = Objects.requireNonNull(enumType, "the enumType must be not null!");
            this.cache = Arrays.stream(enumType.getEnumConstants()).collect(Collectors.toMap(it -> it.getCode().toString(), Function.identity()));
        }

        public T deserialize(JsonParser p, DeserializationContext context) throws IOException {
            return (T)((IEnum)this.cache.get(p.getValueAsString()));
        }

        public String toString() {
            return "EnumDeserializer{enumType=" + this.enumType + '}';
        }
    }
}

