/*
 * Decompiled with CFR 0.152.
 */
package org.ifinalframework.json.jackson.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Optional;
import org.ifinalframework.auto.service.annotation.AutoService;

@AutoService(value=JsonDeserializer.class)
public class LocalDateTimeDeserializer
extends JsonDeserializer<LocalDateTime> {
    public LocalDateTime deserialize(JsonParser p, DeserializationContext context) throws IOException {
        if (!p.isNaN()) {
            long timestamp = p.getValueAsLong();
            ZoneId zone = (ZoneId)Optional.ofNullable(context.getAttribute(ZoneId.class)).orElse(ZoneId.systemDefault());
            Instant instant = Instant.ofEpochMilli(timestamp);
            return LocalDateTime.ofInstant(instant, zone);
        }
        return null;
    }

    public Class<?> handledType() {
        return LocalDateTime.class;
    }
}

