/*
 * Decompiled with CFR 0.152.
 */
package org.ifinalframework.json.jackson.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.ifinalframework.auto.service.annotation.AutoService;

@AutoService(value=JsonSerializer.class)
public class DateSerializer
extends JsonSerializer<Date> {
    public static final DateSerializer INSTANCE = new DateSerializer();
    private final String pattern;

    public DateSerializer(String pattern) {
        this.pattern = pattern;
    }

    public DateSerializer() {
        this(null);
    }

    public void serialize(Date date, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        if (date == null) {
            gen.writeNull();
            return;
        }
        if (this.pattern != null) {
            gen.writeString(new SimpleDateFormat(this.pattern).format(date));
        } else {
            gen.writeNumber(date.getTime());
        }
    }

    public Class<Date> handledType() {
        return Date.class;
    }
}

