/*
 * Decompiled with CFR 0.152.
 */
package org.ifinalframework.json.jackson.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import org.ifinalframework.auto.service.annotation.AutoService;

@AutoService(value=JsonSerializer.class)
public class LocalDateSerializer
extends JsonSerializer<LocalDate> {
    public static final LocalDateSerializer INSTANCE = new LocalDateSerializer();
    private final DateTimeFormatter formatter;

    public LocalDateSerializer() {
        this(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
    }

    public LocalDateSerializer(DateTimeFormatter formatter) {
        this.formatter = formatter;
    }

    public void serialize(LocalDate localDate, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        if (localDate == null) {
            gen.writeNull();
            return;
        }
        if (this.formatter != null) {
            gen.writeString(localDate.format(this.formatter));
        } else {
            gen.writeNumber(localDate.toEpochDay());
        }
    }

    public Class<LocalDate> handledType() {
        return LocalDate.class;
    }
}

