/*
 * Decompiled with CFR 0.152.
 */
package org.ifinalframework.json.jackson.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import org.ifinalframework.auto.service.annotation.AutoService;

@AutoService(value=JsonSerializer.class)
public class LocalDateTimeSerializer
extends JsonSerializer<LocalDateTime> {
    private DateTimeFormatter formatter;

    public LocalDateTimeSerializer() {
    }

    public LocalDateTimeSerializer(DateTimeFormatter formatter) {
        this.formatter = formatter;
    }

    public void serialize(LocalDateTime localDateTime, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        if (localDateTime == null) {
            gen.writeNull();
            return;
        }
        if (this.formatter != null) {
            gen.writeString(localDateTime.format(this.formatter));
        } else {
            gen.writeNumber(localDateTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli());
        }
    }

    public Class<LocalDateTime> handledType() {
        return LocalDateTime.class;
    }
}

