/*
 * Decompiled with CFR 0.152.
 */
package org.ifinalframework.web.autoconfiguration;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.ifinalframework.util.Asserts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.mvc.method.annotation.AbstractMessageConverterMethodArgumentResolver;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;

public class RequestMappingHandlerAdapterAutoConfiguration
implements ApplicationListener<ApplicationReadyEvent> {
    @Generated
    private static final Logger logger = LoggerFactory.getLogger(RequestMappingHandlerAdapterAutoConfiguration.class);

    public void onApplicationEvent(ApplicationReadyEvent event) {
        try {
            if (event.getSpringApplication().getWebApplicationType() != WebApplicationType.SERVLET) {
                return;
            }
            ConfigurableApplicationContext applicationContext = event.getApplicationContext();
            RequestMappingHandlerAdapter requestMappingHandlerAdapter = (RequestMappingHandlerAdapter)applicationContext.getBean(RequestMappingHandlerAdapter.class);
            this.configureHandlerMethodArgumentResolver((ApplicationContext)applicationContext, requestMappingHandlerAdapter);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
    }

    private void configureHandlerMethodArgumentResolver(ApplicationContext context, RequestMappingHandlerAdapter adapter) {
        ArrayList<HandlerMethodArgumentResolver> argumentResolvers = new ArrayList<HandlerMethodArgumentResolver>();
        context.getBeanProvider(HandlerMethodArgumentResolver.class).stream().forEachOrdered(argumentResolvers::add);
        List defaultArgumentResolvers = adapter.getArgumentResolvers();
        if (Asserts.nonEmpty((Object)defaultArgumentResolvers)) {
            for (HandlerMethodArgumentResolver argumentResolver : defaultArgumentResolvers) {
                if (argumentResolver instanceof AbstractMessageConverterMethodArgumentResolver) {
                    Optional.ofNullable(ReflectionUtils.findField(argumentResolver.getClass(), (String)"messageConverters")).ifPresent(messageConverters -> {
                        ReflectionUtils.makeAccessible((Field)messageConverters);
                        ReflectionUtils.setField((Field)messageConverters, (Object)argumentResolver, (Object)adapter.getMessageConverters());
                    });
                }
                argumentResolvers.add(argumentResolver);
            }
        }
        adapter.setArgumentResolvers(argumentResolvers);
    }
}

