/*
 * Decompiled with CFR 0.152.
 */
package org.ifinalframework.web.autoconfiguration.cors;

import java.util.Objects;
import org.ifinalframework.web.autoconfiguration.cors.CorsProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.CorsRegistration;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@ConditionalOnClass(value={WebMvcConfigurer.class})
@EnableConfigurationProperties(value={CorsProperties.class})
public class CorsWebMvcConfigurerAutoConfiguration
implements WebMvcConfigurer {
    private final CorsProperties corsProperties;

    public CorsWebMvcConfigurerAutoConfiguration(CorsProperties corsProperties) {
        this.corsProperties = corsProperties;
    }

    public void addCorsMappings(CorsRegistry registry) {
        if (Objects.isNull(this.corsProperties.getMapping())) {
            return;
        }
        CorsRegistration registration = registry.addMapping(this.corsProperties.getMapping());
        if (Objects.nonNull(this.corsProperties.getAllowCredentials())) {
            registration.allowCredentials(this.corsProperties.getAllowCredentials().booleanValue());
        }
        if (Objects.nonNull(this.corsProperties.getAllowedOrigins())) {
            registration.allowedOrigins(this.corsProperties.getAllowedOrigins());
        }
        if (Objects.nonNull(this.corsProperties.getAllowedHeaders())) {
            registration.allowedHeaders(this.corsProperties.getAllowedHeaders());
        }
        if (Objects.nonNull(this.corsProperties.getAllowedMethods())) {
            registration.allowedMethods(this.corsProperties.getAllowedMethods());
        }
    }
}

