/*
 * Decompiled with CFR 0.152.
 */
package org.ifinalframework.web.autoconfiguration.i18n;

import org.ifinalframework.context.util.Messages;
import org.ifinalframework.web.autoconfiguration.i18n.I18NProperties;
import org.ifinalframework.web.i18n.I18NLocaleResolver;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.i18n.LocaleChangeInterceptor;

@Configuration
@ConditionalOnClass(value={LocaleResolver.class})
@EnableConfigurationProperties(value={I18NProperties.class})
public class I18NWebMvcConfigurerAutoConfiguration
implements WebMvcConfigurer {
    private final I18NProperties properties;

    public I18NWebMvcConfigurerAutoConfiguration(I18NProperties properties, MessageSource messageSource) {
        this.properties = properties;
        Messages.setMessageSource((MessageSource)messageSource);
    }

    @Bean(name={"localeResolver"})
    @ConditionalOnMissingBean(value={LocaleResolver.class})
    public I18NLocaleResolver localeResolver() {
        I18NLocaleResolver localeResolver = new I18NLocaleResolver();
        localeResolver.setDefaultLocale(this.properties.getDefaultLocale());
        localeResolver.setSupportedLocales(this.properties.getSupportedLocales());
        localeResolver.setParamName(this.properties.getParamName());
        localeResolver.setHeaderName(this.properties.getHeaderName());
        localeResolver.setCookieName(this.properties.getCookieName());
        localeResolver.setCookieMaxAge(this.properties.getCookieMaxAge());
        localeResolver.setCookieDomain(this.properties.getCookieDomain());
        localeResolver.setCookiePath(this.properties.getCookiePath());
        return localeResolver;
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.localeChangeInterceptor());
    }

    public LocaleChangeInterceptor localeChangeInterceptor() {
        LocaleChangeInterceptor interceptor = new LocaleChangeInterceptor();
        interceptor.setParamName(this.properties.getParamName());
        return interceptor;
    }
}

