/*
 * Decompiled with CFR 0.152.
 */
package org.ifinalframework.web.autoconfiguration.trace;

import org.ifinalframework.web.autoconfiguration.trace.TraceProperties;
import org.ifinalframework.web.interceptor.TraceHandlerInterceptor;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnBean(value={TraceHandlerInterceptor.class})
@EnableConfigurationProperties(value={TraceProperties.class})
public class TraceHandlerInterceptorAutoConfiguration
implements InitializingBean {
    private final TraceProperties properties;
    private final TraceHandlerInterceptor traceHandlerInterceptor;

    public TraceHandlerInterceptorAutoConfiguration(TraceProperties properties, TraceHandlerInterceptor traceHandlerInterceptor) {
        this.properties = properties;
        this.traceHandlerInterceptor = traceHandlerInterceptor;
    }

    public void afterPropertiesSet() {
        this.traceHandlerInterceptor.setTraceName(this.properties.getName());
        this.traceHandlerInterceptor.setTraceName(this.properties.getParam());
        this.traceHandlerInterceptor.setHeaderName(this.properties.getHeader());
    }
}

