/*
 * Decompiled with CFR 0.152.
 */
package org.ifinalframework.web.converter;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.ifinalframework.core.IEnum;
import org.ifinalframework.util.Asserts;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

@Component
public class EnumConverterFactory
implements ConverterFactory<String, IEnum> {
    @NonNull
    public <T extends IEnum> Converter<String, T> getConverter(@NonNull Class<T> targetType) {
        return new EnumConverter<T>(targetType);
    }

    public static class EnumConverter<T extends IEnum>
    implements Converter<String, T> {
        private final Class<T> enumType;
        private final Map<String, T> enumMap;

        public EnumConverter(Class<T> enumType) {
            this.enumType = enumType;
            IEnum[] enums = (IEnum[])this.enumType.getEnumConstants();
            this.enumMap = Arrays.stream(enums).collect(Collectors.toMap(e -> e.getCode().toString(), e -> e));
        }

        public T convert(@NonNull String source) {
            return (T)(Asserts.isBlank((String)source) ? null : (IEnum)this.enumMap.get(source.trim()));
        }

        public String toString() {
            return this.enumType.getSimpleName() + "Converter";
        }
    }
}

