/*
 * Decompiled with CFR 0.152.
 */
package org.ifinalframework.web.converter;

import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.aspectj.lang.annotation.Aspect;
import org.ifinalframework.context.exception.NotFoundException;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Controller;
import org.springframework.stereotype.Service;
import org.springframework.util.ClassUtils;
import org.springframework.web.bind.annotation.RestController;

@Component
public class String2ClassConverter
implements Converter<String, Class<?>> {
    private final Map<String, Class<? extends Annotation>> shortAnnotations = Stream.of(RestController.class, Controller.class, Component.class, Service.class, Configuration.class, EnableAutoConfiguration.class, Aspect.class).collect(Collectors.toMap(Class::getSimpleName, Function.identity()));

    @NonNull
    public Class<?> convert(@NonNull String source) {
        try {
            return this.shortAnnotations.containsKey(source) ? this.shortAnnotations.get(source) : ClassUtils.forName((String)source, (ClassLoader)this.getClass().getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new NotFoundException(e.getMessage(), new Object[0]);
        }
    }

    @Generated
    public Map<String, Class<? extends Annotation>> getShortAnnotations() {
        return this.shortAnnotations;
    }
}

