/*
 * Decompiled with CFR 0.152.
 */
package org.ifinalframework.web.exception;

import org.ifinalframework.context.exception.UnCatchException;
import org.ifinalframework.context.exception.handler.GlobalExceptionHandler;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
@ConditionalOnBean(value={GlobalExceptionHandler.class})
public class RestControllerExceptionHandler {
    private final GlobalExceptionHandler<?> globalExceptionHandler;

    public RestControllerExceptionHandler(GlobalExceptionHandler<?> globalExceptionHandler) {
        this.globalExceptionHandler = globalExceptionHandler;
    }

    @ExceptionHandler
    @ResponseBody
    public Object handlerException(Throwable throwable) {
        if (this.globalExceptionHandler != null) {
            return this.globalExceptionHandler.handle(throwable);
        }
        throw new UnCatchException(throwable);
    }
}

