/*
 * Decompiled with CFR 0.152.
 */
package org.ifinalframework.web.filter;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.ifinalframework.util.Asserts;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;

@Component
public class HeaderHiddenHttpMethodFilter
extends OncePerRequestFilter {
    public static final String DEFAULT_METHOD_HEADER = "Hidden-Http-Method";
    private static final List<String> ALLOWED_METHODS = Collections.unmodifiableList(Arrays.asList(HttpMethod.PUT.name(), HttpMethod.DELETE.name(), HttpMethod.PATCH.name()));
    private String methodHeader = "Hidden-Http-Method";

    public void setMethodHeader(String methodHeader) {
        Asserts.isEmpty((Object)methodHeader, (String)"'methodHeader' must not be empty", (Object[])new Object[0]);
        this.methodHeader = methodHeader;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String method;
        String headerValue;
        Object requestToUse = request;
        if ("POST".equals(request.getMethod()) && request.getAttribute("javax.servlet.error.exception") == null && StringUtils.hasLength((String)(headerValue = request.getHeader(this.methodHeader))) && ALLOWED_METHODS.contains(method = headerValue.toUpperCase(Locale.ENGLISH))) {
            requestToUse = new HttpMethodRequestWrapper(request, method);
        }
        filterChain.doFilter((ServletRequest)requestToUse, (ServletResponse)response);
    }

    private static class HttpMethodRequestWrapper
    extends HttpServletRequestWrapper {
        private final String method;

        HttpMethodRequestWrapper(HttpServletRequest request, String method) {
            super(request);
            this.method = method;
        }

        public String getMethod() {
            return this.method;
        }
    }
}

