/*
 * Decompiled with CFR 0.152.
 */
package org.ifinalframework.web.filter;

import java.io.IOException;
import javax.annotation.Resource;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ifinalframework.context.user.UserContextHolder;
import org.ifinalframework.core.IUser;
import org.ifinalframework.web.auth.TokenService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

@Component
@ConditionalOnBean(value={TokenService.class})
public class TokenFilter
extends OncePerRequestFilter {
    @Resource
    private TokenService<? extends IUser> tokenService;

    protected void doFilterInternal(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull FilterChain filterChain) throws ServletException, IOException {
        UserContextHolder.setUser((IUser)this.tokenService.token(request, response), (boolean)true);
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

