/*
 * Decompiled with CFR 0.152.
 */
package org.ifinalframework.web.i18n;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.ifinalframework.util.Asserts;
import org.springframework.lang.NonNull;
import org.springframework.web.servlet.i18n.CookieLocaleResolver;

public class I18NLocaleResolver
extends CookieLocaleResolver {
    private static final String ACCEPT_LANGUAGE_HEADER = "Accept-Language";
    private final List<Locale> supportedLocales = new ArrayList<Locale>(4);
    private String paramName;
    private String headerName;

    public Locale resolveLocale(@NonNull HttpServletRequest request) {
        String header;
        Locale locale = null;
        String lang = request.getParameter(this.paramName);
        if (Asserts.nonBlank((String)lang)) {
            locale = Locale.forLanguageTag(lang);
        }
        if (locale == null && Asserts.nonBlank((String)this.headerName) && Asserts.nonBlank((String)(header = request.getHeader(this.headerName)))) {
            locale = Locale.forLanguageTag(header);
        }
        if (locale == null && request.getHeader(ACCEPT_LANGUAGE_HEADER) != null && !this.isSupportedLocale(locale = request.getLocale())) {
            locale = this.findSupportedLocale(request, locale);
        }
        if (locale == null) {
            locale = super.resolveLocale(request);
        }
        if (!this.isSupportedLocale(locale)) {
            locale = this.getDefaultLocale();
        }
        return locale;
    }

    private boolean isSupportedLocale(Locale locale) {
        return this.supportedLocales.isEmpty() || this.supportedLocales.contains(locale);
    }

    private Locale findSupportedLocale(HttpServletRequest request, Locale fallback) {
        Enumeration requestLocales = request.getLocales();
        while (requestLocales.hasMoreElements()) {
            Locale locale = (Locale)requestLocales.nextElement();
            if (!this.getSupportedLocales().contains(locale)) continue;
            return locale;
        }
        return fallback;
    }

    public List<Locale> getSupportedLocales() {
        return this.supportedLocales;
    }

    public void setSupportedLocales(List<Locale> locales) {
        this.supportedLocales.clear();
        if (locales != null) {
            this.supportedLocales.addAll(locales);
        }
    }

    @Generated
    public void setParamName(String paramName) {
        this.paramName = paramName;
    }

    @Generated
    public void setHeaderName(String headerName) {
        this.headerName = headerName;
    }

    @Generated
    public String getParamName() {
        return this.paramName;
    }

    @Generated
    public String getHeaderName() {
        return this.headerName;
    }
}

