/*
 * Decompiled with CFR 0.152.
 */
package org.ifinalframework.web.interceptor;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.ifinalframework.context.user.UserContextHolder;
import org.ifinalframework.core.IUser;
import org.ifinalframework.util.Reflections;
import org.ifinalframework.web.annotation.auth.Auth;
import org.ifinalframework.web.auth.AuthService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.AsyncHandlerInterceptor;

@Component
@ConditionalOnBean(value={AuthService.class})
public class AuthHandlerInterceptor
implements AsyncHandlerInterceptor {
    @Generated
    private static final Logger logger = LoggerFactory.getLogger(AuthHandlerInterceptor.class);
    private final Map<Class<? extends Annotation>, AuthService> authServices = new HashMap<Class<? extends Annotation>, AuthService>();

    public AuthHandlerInterceptor(ObjectProvider<AuthService<?, ?>> authServiceProvider) {
        for (AuthService authService : authServiceProvider) {
            Class targetClass = AopUtils.getTargetClass((Object)authService);
            Class authAnnotation = Reflections.findParameterizedInterfaceArgumentClass((Class)targetClass, AuthService.class, (int)0);
            logger.info("register auth service of {} for @{}", (Object)targetClass, (Object)authAnnotation);
            this.authServices.put(authAnnotation, authService);
        }
    }

    public boolean preHandle(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull Object handler) throws Exception {
        Auth auth;
        Annotation authAnnotation = auth = this.findHandlerAuth(handler, Auth.class);
        if (auth != null) {
            IUser user = UserContextHolder.getUser();
            Class<? extends Annotation> annotation = auth.value();
            if (Auth.class.equals(annotation)) {
                authAnnotation = this.findHandlerAuth(handler, annotation);
            }
            Objects.requireNonNull(authAnnotation);
            this.authServices.get(annotation).auth(user, authAnnotation, request, response, handler);
        }
        return true;
    }

    private <A extends Annotation> A findHandlerAuth(@NonNull Object handler, Class<A> ann) {
        if (handler instanceof HandlerMethod) {
            Annotation annotation = AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)((HandlerMethod)handler).getMethod(), ann);
            if (annotation != null) {
                return (A)annotation;
            }
            return (A)AnnotatedElementUtils.findMergedAnnotation(((HandlerMethod)handler).getMethod().getDeclaringClass(), ann);
        }
        return null;
    }
}

