/*
 * Decompiled with CFR 0.152.
 */
package org.ifinalframework.web.interceptor;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ifinalframework.web.annotation.servlet.Interceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.web.servlet.AsyncHandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

@Interceptor
public class DurationHandlerInterceptor
implements AsyncHandlerInterceptor {
    private static final String DURATION_ATTRIBUTE_PREFIX = DurationHandlerInterceptor.class.getCanonicalName();
    public static final String DURATION_START_ATTRIBUTE = String.join((CharSequence)".", DURATION_ATTRIBUTE_PREFIX, "start");
    public static final String DURATION_END_ATTRIBUTE = String.join((CharSequence)".", DURATION_ATTRIBUTE_PREFIX, "end");
    public static final String DURATION_ATTRIBUTE = String.join((CharSequence)".", DURATION_ATTRIBUTE_PREFIX, "duration");
    private static final Logger logger = LoggerFactory.getLogger(DurationHandlerInterceptor.class);

    public boolean preHandle(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull Object handler) {
        String uri = request.getRequestURI();
        long durationStart = System.currentTimeMillis();
        request.setAttribute(DURATION_START_ATTRIBUTE, (Object)durationStart);
        if (logger.isDebugEnabled()) {
            logger.debug("METHOD={},URI={},START={}", new Object[]{request.getMethod(), uri, durationStart});
        }
        return true;
    }

    public void postHandle(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull Object handler, ModelAndView modelAndView) {
        Long durationStart = (Long)request.getAttribute(DURATION_START_ATTRIBUTE);
        String uri = request.getRequestURI();
        long durationEnd = System.currentTimeMillis();
        long duration = durationEnd - durationStart;
        request.setAttribute(DURATION_END_ATTRIBUTE, (Object)durationEnd);
        request.setAttribute(DURATION_ATTRIBUTE, (Object)duration);
        if (logger.isDebugEnabled()) {
            logger.debug("METHOD={},URI={},START={},DURATION={}", new Object[]{request.getMethod(), uri, durationEnd, duration});
        }
    }
}

