/*
 * Decompiled with CFR 0.152.
 */
package org.ifinalframework.web.interceptor;

import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ifinalframework.core.result.Column;
import org.ifinalframework.web.annotation.response.ResponseColumn;
import org.ifinalframework.web.annotation.response.ResponseHelper;
import org.ifinalframework.web.annotation.servlet.Interceptor;
import org.springframework.lang.NonNull;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

@Interceptor
public class ResponseColumnHandlerInterceptor
implements HandlerInterceptor {
    public boolean preHandle(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull Object handler) throws Exception {
        if (handler instanceof HandlerMethod && ((HandlerMethod)handler).hasMethodAnnotation(ResponseColumn.ResponseColumns.class)) {
            ResponseColumn.ResponseColumns responseColumns = (ResponseColumn.ResponseColumns)Objects.requireNonNull(((HandlerMethod)handler).getMethodAnnotation(ResponseColumn.ResponseColumns.class));
            ResponseHelper.setResponseColumn(request, Arrays.stream(responseColumns.value()).map(it -> new Column(it.key(), it.name(), it.value())).collect(Collectors.toList()));
        }
        return true;
    }
}

