/*
 * Decompiled with CFR 0.152.
 */
package org.ifinalframework.web.interceptor;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.ifinalframework.core.generator.TraceGenerator;
import org.ifinalframework.core.generator.UuidTraceGenerator;
import org.ifinalframework.util.Asserts;
import org.ifinalframework.web.annotation.servlet.Interceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.core.annotation.Order;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.web.servlet.HandlerInterceptor;

@Order(value=-2147483648)
@Interceptor
public class TraceHandlerInterceptor
implements HandlerInterceptor {
    public static final String TRACE_ATTRIBUTE = TraceHandlerInterceptor.class.getCanonicalName() + ".trace";
    private static final Logger logger = LoggerFactory.getLogger(TraceHandlerInterceptor.class);
    private static final String TRACE = "trace";
    private String traceName = "trace";
    private String paramName = "trace";
    private String headerName = "trace";
    private TraceGenerator generator = new UuidTraceGenerator();

    public boolean preHandle(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull Object handler) {
        String trace = null;
        if (Asserts.nonEmpty((Object)this.paramName)) {
            trace = request.getParameter(this.paramName);
        }
        if (Asserts.isNull(trace) && Asserts.nonEmpty((Object)this.headerName)) {
            trace = request.getHeader(this.headerName);
        }
        if (Asserts.isNull((Object)trace)) {
            trace = (String)request.getAttribute(TRACE_ATTRIBUTE);
        }
        if (trace == null && this.generator != null) {
            trace = this.generator.generate();
        }
        request.setAttribute(TRACE_ATTRIBUTE, (Object)trace);
        MDC.put((String)this.traceName, (String)trace);
        return true;
    }

    public void afterCompletion(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull Object handler, @Nullable Exception ex) throws Exception {
        logger.info("remove trace from MDC context");
        MDC.remove((String)this.traceName);
    }

    @Generated
    public void setTraceName(String traceName) {
        this.traceName = traceName;
    }

    @Generated
    public void setParamName(String paramName) {
        this.paramName = paramName;
    }

    @Generated
    public void setHeaderName(String headerName) {
        this.headerName = headerName;
    }

    @Generated
    public void setGenerator(TraceGenerator generator) {
        this.generator = generator;
    }
}

