/*
 * Decompiled with CFR 0.152.
 */
package org.ifinalframework.web.mvc.config;

import java.util.List;
import java.util.ServiceLoader;
import lombok.Generated;
import org.ifinalframework.util.Asserts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.core.convert.converter.ConverterFactory;
import org.springframework.format.FormatterRegistry;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Component
public class ConverterFactoryWebMvcConfigurer
implements WebMvcConfigurer {
    @Generated
    private static final Logger logger = LoggerFactory.getLogger(ConverterFactoryWebMvcConfigurer.class);
    private final List<ConverterFactory<?, ?>> converterFactories;

    public ConverterFactoryWebMvcConfigurer(ObjectProvider<List<ConverterFactory<?, ?>>> converterFactoriesProvider) {
        this.converterFactories = (List)converterFactoriesProvider.getIfAvailable();
    }

    public void addFormatters(@NonNull FormatterRegistry registry) {
        logger.info("start register converterFactories ...");
        if (Asserts.nonEmpty(this.converterFactories)) {
            this.converterFactories.forEach(item -> this.addConverterFactory(registry, (ConverterFactory<?, ?>)item));
        }
        ServiceLoader.load(ConverterFactory.class).forEach(item -> this.addConverterFactory(registry, (ConverterFactory<?, ?>)item));
        logger.info("finish register converterFactories ...");
    }

    private void addConverterFactory(FormatterRegistry registry, ConverterFactory<?, ?> factory) {
        if (logger.isInfoEnabled()) {
            logger.info("addConverterFactory: {}", (Object)factory.getClass().getName());
        }
        registry.addConverterFactory(factory);
    }
}

