/*
 * Decompiled with CFR 0.152.
 */
package org.ifinalframework.web.mvc.config;

import java.lang.reflect.AnnotatedElement;
import java.util.List;
import java.util.function.Predicate;
import lombok.Generated;
import org.ifinalframework.web.mvc.config.HandlerInterceptorCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Component
public class HandlerInterceptorWebMvcConfigurer
implements WebMvcConfigurer {
    @Generated
    private static final Logger logger = LoggerFactory.getLogger(HandlerInterceptorWebMvcConfigurer.class);
    private final List<HandlerInterceptor> handlerInterceptors;
    private final List<HandlerInterceptorCustomizer> handlerInterceptorCustomizers;

    public HandlerInterceptorWebMvcConfigurer(ObjectProvider<List<HandlerInterceptor>> handlerInterceptorsObjectProvider, ObjectProvider<List<HandlerInterceptorCustomizer>> handlerInterceptorCustomizersProvider) {
        this.handlerInterceptors = (List)handlerInterceptorsObjectProvider.getIfAvailable();
        this.handlerInterceptorCustomizers = (List)handlerInterceptorCustomizersProvider.getIfAvailable();
    }

    public void addInterceptors(@NonNull InterceptorRegistry registry) {
        this.handlerInterceptors.stream().filter(new ComponentHandlerFilter()).forEach(item -> this.addInterceptor(registry, (HandlerInterceptor)item));
    }

    private void addInterceptor(@NonNull InterceptorRegistry registry, @NonNull HandlerInterceptor interceptor) {
        InterceptorRegistration interceptorRegistration = registry.addInterceptor(interceptor);
        if (!CollectionUtils.isEmpty(this.handlerInterceptorCustomizers)) {
            for (HandlerInterceptorCustomizer customizer : this.handlerInterceptorCustomizers) {
                customizer.customize(interceptorRegistration, interceptor);
            }
        }
        Class targetClass = AopUtils.getTargetClass((Object)interceptor);
        logger.info("==> add interceptor={}", (Object)targetClass);
    }

    private static class ComponentHandlerFilter
    implements Predicate<HandlerInterceptor> {
        private ComponentHandlerFilter() {
        }

        @Override
        public boolean test(HandlerInterceptor handlerInterceptor) {
            return AnnotatedElementUtils.isAnnotated((AnnotatedElement)AopUtils.getTargetClass((Object)handlerInterceptor), Component.class);
        }
    }
}

