/*
 * Decompiled with CFR 0.152.
 */
package org.ifinalframework.web.reactive;

import java.lang.reflect.Type;
import org.ifinalframework.context.converter.result.Object2ResultConverter;
import org.ifinalframework.core.result.Result;
import org.ifinalframework.web.annotation.condition.ConditionalOnReactiveWebApplication;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.MethodParameter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.ResolvableType;
import org.springframework.http.codec.ServerCodecConfigurer;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;
import org.springframework.web.reactive.HandlerResult;
import org.springframework.web.reactive.accept.RequestedContentTypeResolver;
import org.springframework.web.reactive.result.method.annotation.ResponseBodyResultHandler;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@Component
@ConditionalOnReactiveWebApplication
public class ResultHandlerResultHandler
extends ResponseBodyResultHandler {
    private static final Object2ResultConverter OBJECT_2_RESULT_CONVERTER = new Object2ResultConverter();

    @Autowired
    public ResultHandlerResultHandler(@Qualifier(value="webFluxAdapterRegistry") ReactiveAdapterRegistry reactiveAdapterRegistry, ServerCodecConfigurer serverCodecConfigurer, @Qualifier(value="webFluxContentTypeResolver") RequestedContentTypeResolver contentTypeResolver) {
        super(serverCodecConfigurer.getWriters(), contentTypeResolver, reactiveAdapterRegistry);
        this.setOrder(Integer.MIN_VALUE);
    }

    public Mono<Void> handleResult(ServerWebExchange exchange, HandlerResult result) {
        Result body = OBJECT_2_RESULT_CONVERTER.convert(result.getReturnValue());
        MethodParameter bodyTypeParameter = result.getReturnTypeSource();
        ReturnValueMethodParameter actualParam = new ReturnValueMethodParameter(bodyTypeParameter, body);
        return this.writeBody(body, actualParam, actualParam, exchange);
    }

    private static class ReturnValueMethodParameter
    extends MethodParameter {
        private final Object returnValue;

        public ReturnValueMethodParameter(MethodParameter origin, Object returnValue) {
            super(origin.getMethod(), origin.getParameterIndex());
            this.returnValue = returnValue;
        }

        @NonNull
        public Class<?> getParameterType() {
            return this.returnValue != null ? this.returnValue.getClass() : super.getParameterType();
        }

        @NonNull
        public Type getGenericParameterType() {
            return ResolvableType.forClass(this.getParameterType()).getType();
        }
    }
}

