/*
 * Decompiled with CFR 0.152.
 */
package org.ifinalframework.web.resolver;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.ifinalframework.context.exception.BadRequestException;
import org.ifinalframework.json.Json;
import org.ifinalframework.util.Asserts;
import org.ifinalframework.web.annotation.bind.RequestJsonParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;
import org.springframework.util.StreamUtils;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

@Component
public final class RequestJsonParamHandlerMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    @Generated
    private static final Logger logger = LoggerFactory.getLogger(RequestJsonParamHandlerMethodArgumentResolver.class);
    private Charset defaultCharset = StandardCharsets.UTF_8;

    public boolean supportsParameter(@NonNull MethodParameter parameter) {
        return parameter.hasParameterAnnotation(RequestJsonParam.class);
    }

    public Object resolveArgument(@NonNull MethodParameter parameter, @Nullable ModelAndViewContainer mavContainer, @NonNull NativeWebRequest webRequest, @Nullable WebDataBinderFactory binderFactory) throws Exception {
        String contentType = webRequest.getHeader("content-type");
        String value = Objects.nonNull(contentType) && contentType.startsWith("application/json") ? this.parseBody(webRequest) : this.parseParameter(parameter, webRequest);
        if (Objects.isNull(value)) {
            return null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("parse RequestJsonParam name={},value={},", (Object)parameter.getParameterName(), (Object)value);
        }
        return this.parseJson(value, parameter);
    }

    private String parseBody(@NonNull NativeWebRequest webRequest) throws IOException {
        Object nativeRequest = webRequest.getNativeRequest();
        if (nativeRequest instanceof HttpServletRequest) {
            ServletServerHttpRequest inputMessage = new ServletServerHttpRequest((HttpServletRequest)nativeRequest);
            Charset charset = this.getContentTypeCharset(inputMessage.getHeaders().getContentType());
            return StreamUtils.copyToString((InputStream)inputMessage.getBody(), (Charset)charset);
        }
        return null;
    }

    private String parseParameter(@NonNull MethodParameter parameter, @NonNull NativeWebRequest webRequest) {
        RequestJsonParam requestJsonParam = (RequestJsonParam)Objects.requireNonNull(parameter.getParameterAnnotation(RequestJsonParam.class), "requestJsonParam annotation is null");
        String parameterName = this.getParameterName(requestJsonParam, parameter);
        Objects.requireNonNull(parameterName);
        String value = webRequest.getParameter(parameterName);
        if (Asserts.isBlank((String)value) && requestJsonParam.required()) {
            throw new BadRequestException(String.format("parameter %s is required", parameterName), new Object[0]);
        }
        if (Asserts.isBlank((String)value) && !"\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n".equals(requestJsonParam.defaultValue())) {
            value = requestJsonParam.defaultValue();
        }
        if (Asserts.isBlank((String)value)) {
            return null;
        }
        return value;
    }

    private Object parseJson(String json, MethodParameter parameter) {
        return Json.toObject((String)json, (Type)parameter.getGenericParameterType());
    }

    private String getParameterName(RequestJsonParam requestJsonParam, MethodParameter parameter) {
        return Asserts.isEmpty((Object)requestJsonParam.value()) ? parameter.getParameterName() : requestJsonParam.value().trim();
    }

    @NonNull
    private Charset getContentTypeCharset(@Nullable MediaType contentType) {
        if (contentType != null && contentType.getCharset() != null) {
            return Optional.ofNullable(contentType.getCharset()).orElse(this.getDefaultCharset());
        }
        return this.getDefaultCharset();
    }

    @NonNull
    public Charset getDefaultCharset() {
        return this.defaultCharset;
    }

    @Generated
    public void setDefaultCharset(Charset defaultCharset) {
        this.defaultCharset = defaultCharset;
    }
}

