/*
 * Decompiled with CFR 0.152.
 */
package org.ifinalframework.web.response.advice;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.ifinalframework.context.expression.Spel;
import org.ifinalframework.core.result.Column;
import org.ifinalframework.core.result.Result;
import org.ifinalframework.web.annotation.response.ResponseHelper;
import org.ifinalframework.web.response.advice.RestResponseBodyAdvice;
import org.springframework.context.expression.MapAccessor;
import org.springframework.core.MethodParameter;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class ResultColumnResponseBodyAdvice
implements RestResponseBodyAdvice<Result<List<?>>> {
    public static final MapAccessor ACCESSOR = new MapAccessor();

    @Override
    @Nullable
    public Result<List<?>> doBeforeBodyWrite(@Nullable Result<List<?>> body, @NonNull MethodParameter returnType, @NonNull MediaType selectedContentType, @NonNull Class<? extends HttpMessageConverter<?>> selectedConverterType, @NonNull ServerHttpRequest request, @NonNull ServerHttpResponse response) {
        if (Objects.isNull(body)) {
            return null;
        }
        HttpServletRequest servletRequest = ((ServletServerHttpRequest)request).getServletRequest();
        List<Column> responseColumn = ResponseHelper.getResponseColumn(servletRequest);
        if (CollectionUtils.isEmpty(responseColumn)) {
            return body;
        }
        body.setHeader(responseColumn);
        if (!CollectionUtils.isEmpty((Collection)((Collection)body.getData()))) {
            ArrayList list = new ArrayList(((List)body.getData()).size());
            for (Object data : (List)body.getData()) {
                LinkedHashMap<String, Object> item = new LinkedHashMap<String, Object>();
                StandardEvaluationContext context = new StandardEvaluationContext(data);
                context.addPropertyAccessor((PropertyAccessor)ACCESSOR);
                for (Column column : responseColumn) {
                    item.put(column.getKey(), Spel.getValue((String)column.getValue(), (Object)context));
                }
                list.add(item);
            }
            body.setData(list);
        }
        return body;
    }
}

