/*
 * Decompiled with CFR 0.152.
 */
package org.ifinalframework.web.response.advice.result;

import java.time.Duration;
import org.ifinalframework.context.converter.result.Object2ResultConverter;
import org.ifinalframework.context.user.UserContextHolder;
import org.ifinalframework.core.result.Result;
import org.ifinalframework.web.interceptor.DurationHandlerInterceptor;
import org.ifinalframework.web.interceptor.TraceHandlerInterceptor;
import org.ifinalframework.web.response.advice.RestResponseBodyAdvice;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.Order;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@Order(value=1000)
@RestControllerAdvice
public class ResultResponseBodyAdvice
implements RestResponseBodyAdvice<Object> {
    private static final Object2ResultConverter object2ResultConverter = new Object2ResultConverter();

    @Override
    public Object doBeforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        Result result = object2ResultConverter.convert(body);
        if (result == null) {
            return null;
        }
        result.setAddress(request.getLocalAddress().getAddress().getHostName());
        result.setIp(String.format("%s:%d", request.getLocalAddress().getAddress().getHostAddress(), request.getLocalAddress().getPort()));
        result.setLocale(LocaleContextHolder.getLocale());
        result.setTimeZone(LocaleContextHolder.getTimeZone());
        result.setOperator(UserContextHolder.getUser());
        if (request instanceof ServletServerHttpRequest) {
            Long durationStart = (Long)((ServletServerHttpRequest)request).getServletRequest().getAttribute(DurationHandlerInterceptor.DURATION_START_ATTRIBUTE);
            if (durationStart != null) {
                result.setDuration(Duration.ofMillis(System.currentTimeMillis() - durationStart));
            }
            String trace = (String)((ServletServerHttpRequest)request).getServletRequest().getAttribute(TraceHandlerInterceptor.TRACE_ATTRIBUTE);
            result.setTrace(trace);
        }
        return result;
    }
}

