/*
 * Decompiled with CFR 0.152.
 */
package org.ifinalframework.javadoc.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.ifinalframework.javadoc.model.Doc;
import org.ifinalframework.javadoc.model.FieldDoc;
import org.ifinalframework.javadoc.model.JavaDocLoader;
import org.ifinalframework.javadoc.model.MethodDoc;
import org.ifinalframework.javadoc.model.jackson.ClassJsonDeserializer;
import org.springframework.lang.NonNull;

public class ClassDoc
extends Doc {
    @NonNull
    @JsonProperty(value="class")
    @JsonDeserialize(using=ClassJsonDeserializer.class)
    private Class<?> type;
    private Map<String, FieldDoc> fieldDocs;
    private List<MethodDoc> methodDocs;

    public static ClassDoc load(Class<?> clazz) {
        return JavaDocLoader.load(clazz);
    }

    public MethodDoc getMethod(Method method) {
        for (MethodDoc methodDoc : this.methodDocs) {
            String[] split = method.toGenericString().split(" ");
            String sign = split[split.length - 1];
            if (!methodDoc.getSignature().replace(" ", "").equals(sign)) continue;
            return methodDoc;
        }
        return null;
    }

    @JsonProperty(value="class")
    @JsonDeserialize(using=ClassJsonDeserializer.class)
    public void setType(@NonNull Class<?> type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.type = type;
    }

    public void setFieldDocs(Map<String, FieldDoc> fieldDocs) {
        this.fieldDocs = fieldDocs;
    }

    public void setMethodDocs(List<MethodDoc> methodDocs) {
        this.methodDocs = methodDocs;
    }

    @NonNull
    public Class<?> getType() {
        return this.type;
    }

    public Map<String, FieldDoc> getFieldDocs() {
        return this.fieldDocs;
    }

    public List<MethodDoc> getMethodDocs() {
        return this.methodDocs;
    }
}

