/*
 * Decompiled with CFR 0.152.
 */
package org.ifinalframework.javadoc.model;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.util.Objects;
import org.ifinalframework.javadoc.model.ClassDoc;
import org.springframework.lang.Nullable;

final class JavaDocLoader {
    private static final ObjectMapper loader = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

    JavaDocLoader() {
    }

    @Nullable
    public static ClassDoc load(Class<?> clazz) {
        try {
            String packagePath = clazz.getPackage().getName().replace(".", "/");
            String javaDocResource = "/META-INF/docs/json/" + packagePath + "/" + clazz.getSimpleName() + ".json";
            byte[] bytes = new byte[8192];
            InputStream inputStream = clazz.getResourceAsStream(javaDocResource);
            if (Objects.isNull(inputStream)) {
                return null;
            }
            int read = inputStream.read(bytes);
            String json = new String(bytes, 0, read);
            return (ClassDoc)loader.readValue(json, ClassDoc.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

