/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.carbons.provider;

import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smackx.carbons.packet.CarbonExtension;
import org.jivesoftware.smackx.forward.packet.Forwarded;
import org.jivesoftware.smackx.forward.provider.ForwardedProvider;
import org.xmlpull.v1.XmlPullParser;

public class CarbonManagerProvider
extends ExtensionElementProvider<CarbonExtension> {
    private static final ForwardedProvider FORWARDED_PROVIDER = new ForwardedProvider();

    public CarbonExtension parse(XmlPullParser parser, int initialDepth) throws Exception {
        CarbonExtension.Direction dir = CarbonExtension.Direction.valueOf(parser.getName());
        Forwarded fwd = null;
        boolean done = false;
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2 && parser.getName().equals("forwarded")) {
                fwd = (Forwarded)FORWARDED_PROVIDER.parse(parser);
                continue;
            }
            if (eventType != 3 || dir != CarbonExtension.Direction.valueOf(parser.getName())) continue;
            done = true;
        }
        if (fwd == null) {
            throw new SmackException("sent/received must contain exactly one <forwarded> tag");
        }
        return new CarbonExtension(dir, fwd);
    }
}

