/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle_filetransfer.element;

import java.io.File;
import java.util.Date;
import org.jivesoftware.smack.packet.Element;
import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smackx.hashes.element.HashElement;
import org.jivesoftware.smackx.jingle.element.JingleContentDescriptionChildElement;
import org.jivesoftware.smackx.jingle_filetransfer.element.Range;

public class JingleFileTransferChild
extends JingleContentDescriptionChildElement {
    public static final String ELEMENT = "file";
    public static final String ELEM_DATE = "date";
    public static final String ELEM_DESC = "desc";
    public static final String ELEM_MEDIA_TYPE = "media-type";
    public static final String ELEM_NAME = "name";
    public static final String ELEM_SIZE = "size";
    private final Date date;
    private final String desc;
    private final HashElement hash;
    private final String mediaType;
    private final String name;
    private final int size;
    private final Range range;

    public JingleFileTransferChild(Date date, String desc, HashElement hash, String mediaType, String name, int size, Range range) {
        this.date = date;
        this.desc = desc;
        this.hash = hash;
        this.mediaType = mediaType;
        this.name = name;
        this.size = size;
        this.range = range;
    }

    public Date getDate() {
        return this.date;
    }

    public String getDescription() {
        return this.desc;
    }

    public HashElement getHash() {
        return this.hash;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public String getName() {
        return this.name;
    }

    public int getSize() {
        return this.size;
    }

    public Range getRange() {
        return this.range;
    }

    public String getElementName() {
        return ELEMENT;
    }

    public CharSequence toXML(String enclosingNamespace) {
        XmlStringBuilder sb = new XmlStringBuilder((NamedElement)this);
        sb.rightAngleBracket();
        sb.optElement(ELEM_DATE, this.date);
        sb.optElement(ELEM_DESC, this.desc);
        sb.optElement(ELEM_MEDIA_TYPE, this.mediaType);
        sb.optElement(ELEM_NAME, this.name);
        sb.optElement((Element)this.range);
        if (this.size > 0) {
            sb.element(ELEM_SIZE, Integer.toString(this.size));
        }
        sb.optElement((Element)this.hash);
        sb.closeElement((NamedElement)this);
        return sb;
    }

    public static Builder getBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private Date date;
        private String desc;
        private HashElement hash;
        private String mediaType;
        private String name;
        private int size;
        private Range range;

        private Builder() {
        }

        public Builder setDate(Date date) {
            this.date = date;
            return this;
        }

        public Builder setDescription(String desc) {
            this.desc = desc;
            return this;
        }

        public Builder setHash(HashElement hash) {
            this.hash = hash;
            return this;
        }

        public Builder setMediaType(String mediaType) {
            this.mediaType = mediaType;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setSize(int size) {
            this.size = size;
            return this;
        }

        public Builder setRange(Range range) {
            this.range = range;
            return this;
        }

        public JingleFileTransferChild build() {
            return new JingleFileTransferChild(this.date, this.desc, this.hash, this.mediaType, this.name, this.size, this.range);
        }

        public Builder setFile(File file) {
            return this.setDate(new Date(file.lastModified())).setName(file.getAbsolutePath().substring(file.getAbsolutePath().lastIndexOf("/") + 1)).setSize((int)file.length());
        }
    }
}

