/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle_filetransfer.provider;

import java.util.ArrayList;
import org.jivesoftware.smackx.hashes.element.HashElement;
import org.jivesoftware.smackx.hashes.provider.HashElementProvider;
import org.jivesoftware.smackx.jingle.element.JingleContentDescriptionChildElement;
import org.jivesoftware.smackx.jingle.provider.JingleContentDescriptionProvider;
import org.jivesoftware.smackx.jingle_filetransfer.element.JingleFileTransfer;
import org.jivesoftware.smackx.jingle_filetransfer.element.JingleFileTransferChild;
import org.jivesoftware.smackx.jingle_filetransfer.element.Range;
import org.jxmpp.util.XmppDateTime;
import org.xmlpull.v1.XmlPullParser;

public class JingleFileTransferProvider
extends JingleContentDescriptionProvider<JingleFileTransfer> {
    public JingleFileTransfer parse(XmlPullParser parser, int initialDepth) throws Exception {
        ArrayList<JingleContentDescriptionChildElement> payloads = new ArrayList<JingleContentDescriptionChildElement>();
        boolean inRange = false;
        JingleFileTransferChild.Builder builder = JingleFileTransferChild.getBuilder();
        HashElement inRangeHash = null;
        int offset = 0;
        int length = -1;
        while (true) {
            int tag = parser.nextTag();
            String elem = parser.getName();
            if (tag == 2) {
                switch (elem) {
                    case "date": {
                        builder.setDate(XmppDateTime.parseXEP0082Date((String)parser.nextText()));
                        break;
                    }
                    case "desc": {
                        builder.setDescription(parser.nextText());
                        break;
                    }
                    case "media-type": {
                        builder.setMediaType(parser.nextText());
                        break;
                    }
                    case "name": {
                        builder.setName(parser.nextText());
                        break;
                    }
                    case "size": {
                        builder.setSize(Integer.parseInt(parser.nextText()));
                        break;
                    }
                    case "range": {
                        inRange = true;
                        String offsetString = parser.getAttributeValue(null, "offset");
                        String lengthString = parser.getAttributeValue(null, "length");
                        offset = offsetString != null ? Integer.parseInt(offsetString) : 0;
                        int n = length = lengthString != null ? Integer.parseInt(lengthString) : -1;
                        if (!parser.isEmptyElementTag()) break;
                        inRange = false;
                        builder.setRange(new Range(offset, length));
                        break;
                    }
                    case "hash": {
                        if (inRange) {
                            inRangeHash = (HashElement)new HashElementProvider().parse(parser);
                            break;
                        }
                        builder.setHash((HashElement)new HashElementProvider().parse(parser));
                    }
                }
                continue;
            }
            if (tag != 3) continue;
            switch (elem) {
                case "range": {
                    inRange = false;
                    builder.setRange(new Range(offset, length, inRangeHash));
                    inRangeHash = null;
                    break;
                }
                case "file": {
                    payloads.add(builder.build());
                    builder = JingleFileTransferChild.getBuilder();
                    break;
                }
                case "description": {
                    return new JingleFileTransfer(payloads);
                }
            }
        }
    }
}

