/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.commands;

import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smackx.commands.AdHocCommand;
import org.jivesoftware.smackx.commands.packet.AdHocCommandData;
import org.jivesoftware.smackx.xdata.Form;

public class RemoteCommand
extends AdHocCommand {
    private XMPPConnection connection;
    private String jid;
    private String sessionID;
    private long packetReplyTimeout;

    protected RemoteCommand(XMPPConnection connection, String node, String jid) {
        this.connection = connection;
        this.jid = jid;
        this.setNode(node);
        this.packetReplyTimeout = SmackConfiguration.getDefaultPacketReplyTimeout();
    }

    @Override
    public void cancel() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        this.executeAction(AdHocCommand.Action.cancel, this.packetReplyTimeout);
    }

    @Override
    public void complete(Form form) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        this.executeAction(AdHocCommand.Action.complete, form, this.packetReplyTimeout);
    }

    @Override
    public void execute() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        this.executeAction(AdHocCommand.Action.execute, this.packetReplyTimeout);
    }

    public void execute(Form form) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        this.executeAction(AdHocCommand.Action.execute, form, this.packetReplyTimeout);
    }

    @Override
    public void next(Form form) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        this.executeAction(AdHocCommand.Action.next, form, this.packetReplyTimeout);
    }

    @Override
    public void prev() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        this.executeAction(AdHocCommand.Action.prev, this.packetReplyTimeout);
    }

    private void executeAction(AdHocCommand.Action action, long packetReplyTimeout) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        this.executeAction(action, null, packetReplyTimeout);
    }

    private void executeAction(AdHocCommand.Action action, Form form, long timeout) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        AdHocCommandData data = new AdHocCommandData();
        data.setType(IQ.Type.SET);
        data.setTo(this.getOwnerJID());
        data.setNode(this.getNode());
        data.setSessionID(this.sessionID);
        data.setAction(action);
        if (form != null) {
            data.setForm(form.getDataFormToSend());
        }
        AdHocCommandData responseData = (AdHocCommandData)this.connection.createPacketCollectorAndSend((IQ)data).nextResultOrThrow();
        this.sessionID = responseData.getSessionID();
        super.setData(responseData);
    }

    @Override
    public String getOwnerJID() {
        return this.jid;
    }
}

