/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.xdata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;

public class FormField {
    public static final String TYPE_BOOLEAN = "boolean";
    public static final String TYPE_FIXED = "fixed";
    public static final String TYPE_HIDDEN = "hidden";
    public static final String TYPE_JID_MULTI = "jid-multi";
    public static final String TYPE_JID_SINGLE = "jid-single";
    public static final String TYPE_LIST_MULTI = "list-multi";
    public static final String TYPE_LIST_SINGLE = "list-single";
    public static final String TYPE_TEXT_MULTI = "text-multi";
    public static final String TYPE_TEXT_PRIVATE = "text-private";
    public static final String TYPE_TEXT_SINGLE = "text-single";
    private String description;
    private boolean required = false;
    private String label;
    private String variable;
    private String type;
    private final List<Option> options = new ArrayList<Option>();
    private final List<String> values = new ArrayList<String>();

    public FormField(String variable) {
        this.variable = variable;
    }

    public FormField() {
        this.type = TYPE_FIXED;
    }

    public String getDescription() {
        return this.description;
    }

    public String getLabel() {
        return this.label;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Option> getOptions() {
        List<Option> list = this.options;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList<Option>(this.options));
        }
    }

    public boolean isRequired() {
        return this.required;
    }

    public String getType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getValues() {
        List<String> list = this.values;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList<String>(this.values));
        }
    }

    public String getVariable() {
        return this.variable;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public void setType(String type) {
        this.type = type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addValue(String value) {
        List<String> list = this.values;
        synchronized (list) {
            this.values.add(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addValues(List<String> newValues) {
        List<String> list = this.values;
        synchronized (list) {
            this.values.addAll(newValues);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetValues() {
        List<String> list = this.values;
        synchronized (list) {
            this.values.removeAll(new ArrayList<String>(this.values));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOption(Option option) {
        List<Option> list = this.options;
        synchronized (list) {
            this.options.add(option);
        }
    }

    public String toXML() {
        XmlStringBuilder buf = new XmlStringBuilder();
        buf.append((CharSequence)"<field");
        if (this.getLabel() != null) {
            buf.append((CharSequence)" label=\"").append((CharSequence)this.getLabel()).append((CharSequence)"\"");
        }
        buf.attribute("var", this.getVariable());
        if (this.getType() != null) {
            buf.append((CharSequence)" type=\"").append((CharSequence)this.getType()).append((CharSequence)"\"");
        }
        buf.append((CharSequence)">");
        if (this.getDescription() != null) {
            buf.append((CharSequence)"<desc>").append((CharSequence)this.getDescription()).append((CharSequence)"</desc>");
        }
        if (this.isRequired()) {
            buf.append((CharSequence)"<required/>");
        }
        for (String value : this.getValues()) {
            buf.element("value", value);
        }
        for (Option option : this.getOptions()) {
            buf.append((CharSequence)option.toXML());
        }
        buf.append((CharSequence)"</field>");
        return buf.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FormField)) {
            return false;
        }
        FormField other = (FormField)obj;
        return this.toXML().equals(other.toXML());
    }

    public int hashCode() {
        return this.toXML().hashCode();
    }

    public static class Option {
        private String label;
        private String value;

        public Option(String value) {
            this.value = value;
        }

        public Option(String label, String value) {
            this.label = label;
            this.value = value;
        }

        public String getLabel() {
            return this.label;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.getLabel();
        }

        public String toXML() {
            StringBuilder buf = new StringBuilder();
            buf.append("<option");
            if (this.getLabel() != null) {
                buf.append(" label=\"").append(this.getLabel()).append("\"");
            }
            buf.append(">");
            buf.append("<value>").append(StringUtils.escapeForXML((String)this.getValue())).append("</value>");
            buf.append("</option>");
            return buf.toString();
        }

        public boolean equals(Object obj) {
            String otherLabel;
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            Option other = (Option)obj;
            if (!this.value.equals(other.value)) {
                return false;
            }
            String thisLabel = this.label == null ? "" : this.label;
            String string = otherLabel = other.label == null ? "" : other.label;
            return thisLabel.equals(otherLabel);
        }

        public int hashCode() {
            int result = 1;
            result = 37 * result + this.value.hashCode();
            result = 37 * result + (this.label == null ? 0 : this.label.hashCode());
            return result;
        }
    }
}

