/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.xhtmlim.provider;

import java.io.IOException;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.provider.PacketExtensionProvider;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.xhtmlim.packet.XHTMLExtension;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class XHTMLExtensionProvider
implements PacketExtensionProvider {
    public static final String BODY_ELEMENT = "body";

    public PacketExtension parseExtension(XmlPullParser parser) throws IOException, XmlPullParserException {
        XHTMLExtension xhtmlExtension = new XHTMLExtension();
        String XHTML_EXTENSION_ELEMENT_NAME = xhtmlExtension.getElementName();
        int startDepth = parser.getDepth();
        int tagDepth = parser.getDepth();
        boolean tagStarted = false;
        StringBuilder buffer = new StringBuilder();
        while (true) {
            int eventType;
            if ((eventType = parser.next()) == 2) {
                boolean appendNamespace = false;
                if (BODY_ELEMENT.equals(parser.getName())) {
                    buffer = new StringBuilder();
                    tagDepth = parser.getDepth();
                    appendNamespace = true;
                }
                XHTMLExtensionProvider.maybeCloseTag(tagStarted, buffer);
                XHTMLExtensionProvider.appendStartTagPartial(buffer, parser, appendNamespace);
                tagStarted = true;
                continue;
            }
            if (eventType == 4) {
                tagStarted = XHTMLExtensionProvider.maybeCloseTag(tagStarted, buffer);
                XHTMLExtensionProvider.appendText(buffer, parser);
                continue;
            }
            if (eventType != 3) continue;
            String name = parser.getName();
            if (XHTML_EXTENSION_ELEMENT_NAME.equals(name) && parser.getDepth() <= startDepth) {
                return xhtmlExtension;
            }
            XHTMLExtensionProvider.appendEndTag(buffer, parser, tagStarted);
            tagStarted = false;
            if (!BODY_ELEMENT.equals(name) || parser.getDepth() > tagDepth) continue;
            xhtmlExtension.addBody(buffer.toString());
        }
    }

    private static void appendStartTagPartial(StringBuilder builder, XmlPullParser parser, boolean withNamespace) {
        String namespace;
        builder.append('<');
        String prefix = parser.getPrefix();
        if (StringUtils.isNotEmpty((CharSequence)prefix)) {
            builder.append(prefix).append(':');
        }
        builder.append(parser.getName());
        int attributesCount = parser.getAttributeCount();
        if (withNamespace && StringUtils.isNotEmpty((CharSequence)(namespace = parser.getNamespace()))) {
            builder.append(" xmlns='").append(namespace).append('\'');
        }
        for (int i = 0; i < attributesCount; ++i) {
            builder.append(' ');
            String attributeNamespace = parser.getAttributeNamespace(i);
            if (StringUtils.isNotEmpty((CharSequence)attributeNamespace)) {
                builder.append(attributeNamespace).append(':');
            }
            builder.append(parser.getAttributeName(i));
            String value = parser.getAttributeValue(i);
            if (value == null) continue;
            builder.append("='").append(StringUtils.escapeForXML((String)value)).append('\'');
        }
    }

    private static void appendEndTag(StringBuilder builder, XmlPullParser parser, boolean tagStarted) {
        if (tagStarted) {
            builder.append("/>");
        } else {
            builder.append("</").append(parser.getName()).append('>');
        }
    }

    private static boolean appendText(StringBuilder builder, XmlPullParser parser) {
        String text = parser.getText();
        if (text == null) {
            return false;
        }
        builder.append(StringUtils.escapeForXML((String)parser.getText()));
        return true;
    }

    private static boolean maybeCloseTag(boolean tagStarted, StringBuilder builder) {
        if (tagStarted) {
            builder.append('>');
        }
        return false;
    }
}

