/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.ping;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.AbstractConnectionListener;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.IQTypeFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.ping.PingFailedListener;
import org.jivesoftware.smackx.ping.packet.Ping;
import org.jivesoftware.smackx.ping.packet.Pong;

public class PingManager
extends Manager {
    public static final String NAMESPACE = "urn:xmpp:ping";
    private static final Logger LOGGER = Logger.getLogger(PingManager.class.getName());
    private static final Map<XMPPConnection, PingManager> INSTANCES = Collections.synchronizedMap(new WeakHashMap());
    private static final PacketFilter PING_PACKET_FILTER = new AndFilter(new PacketFilter[]{new PacketTypeFilter(Ping.class), new IQTypeFilter(IQ.Type.GET)});
    private static final PacketFilter PONG_PACKET_FILTER = new AndFilter(new PacketFilter[]{new PacketTypeFilter(Pong.class), new IQTypeFilter(IQ.Type.RESULT)});
    private static int defaultPingInterval;
    private final Set<PingFailedListener> pingFailedListeners = Collections.synchronizedSet(new HashSet());
    private int pingInterval = defaultPingInterval;
    private ScheduledFuture<?> nextAutomaticPing;
    private long lastPongReceived = -1L;
    private final Runnable pingServerRunnable = new Runnable(){
        private static final int DELTA = 1000;
        private static final int TRIES = 3;

        @Override
        public void run() {
            LOGGER.fine("ServerPingTask run()");
            XMPPConnection connection = PingManager.this.connection();
            if (connection == null) {
                return;
            }
            if (PingManager.this.pingInterval <= 0) {
                return;
            }
            long lastReceivedPong = PingManager.this.getLastReceivedPong();
            if (lastReceivedPong > 0L) {
                long now = System.currentTimeMillis();
                int delta = (int)(((long)(PingManager.this.pingInterval * 1000) - (now - lastReceivedPong)) / 1000L);
                if (delta > 0) {
                    PingManager.this.maybeSchedulePingServerTask(delta);
                    return;
                }
            }
            if (connection.isAuthenticated()) {
                boolean res = false;
                for (int i = 0; i < 3; ++i) {
                    if (i != 0) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                    }
                    try {
                        res = PingManager.this.pingMyServer(false);
                    }
                    catch (SmackException e) {
                        LOGGER.log(Level.WARNING, "SmackError while pinging server", e);
                        res = false;
                    }
                    if (res) break;
                }
                LOGGER.fine("ServerPingTask res=" + res);
                if (!res) {
                    for (PingFailedListener l : PingManager.this.pingFailedListeners) {
                        l.pingFailed();
                    }
                } else {
                    PingManager.this.maybeSchedulePingServerTask();
                }
            } else {
                LOGGER.warning("ServerPingTask: XMPPConnection was not authenticated");
            }
        }
    };

    public static synchronized PingManager getInstanceFor(XMPPConnection connection) {
        PingManager pingManager = INSTANCES.get(connection);
        if (pingManager == null) {
            pingManager = new PingManager(connection);
        }
        return pingManager;
    }

    public static void setDefaultPingInterval(int interval) {
        defaultPingInterval = interval;
    }

    private PingManager(XMPPConnection connection) {
        super(connection);
        ServiceDiscoveryManager sdm = ServiceDiscoveryManager.getInstanceFor(connection);
        sdm.addFeature(NAMESPACE);
        INSTANCES.put(connection, this);
        connection.addPacketListener(new PacketListener(){

            public void processPacket(Packet packet) throws SmackException.NotConnectedException {
                Pong pong = new Pong(packet);
                PingManager.this.connection().sendPacket((Packet)pong);
            }
        }, PING_PACKET_FILTER);
        connection.addPacketListener(new PacketListener(){

            public void processPacket(Packet packet) throws SmackException.NotConnectedException {
                PingManager.this.lastPongReceived = System.currentTimeMillis();
            }
        }, PONG_PACKET_FILTER);
        connection.addConnectionListener((ConnectionListener)new AbstractConnectionListener(){

            public void authenticated(XMPPConnection connection) {
                PingManager.this.maybeSchedulePingServerTask();
            }

            public void connectionClosed() {
                PingManager.this.maybeStopPingServerTask();
            }

            public void connectionClosedOnError(Exception arg0) {
                PingManager.this.maybeStopPingServerTask();
            }
        });
        this.maybeSchedulePingServerTask();
    }

    public boolean ping(String jid, long pingTimeout) throws SmackException.NotConnectedException, SmackException.NoResponseException {
        Ping ping = new Ping(jid);
        try {
            this.connection().createPacketCollectorAndSend((IQ)ping).nextResultOrThrow();
        }
        catch (XMPPException exc) {
            return jid.equals(this.connection().getServiceName());
        }
        return true;
    }

    public boolean ping(String jid) throws SmackException.NotConnectedException, SmackException.NoResponseException {
        return this.ping(jid, this.connection().getPacketReplyTimeout());
    }

    public boolean isPingSupported(String jid) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        return ServiceDiscoveryManager.getInstanceFor(this.connection()).supportsFeature(jid, NAMESPACE);
    }

    public boolean pingMyServer() throws SmackException.NotConnectedException {
        return this.pingMyServer(true);
    }

    public boolean pingMyServer(boolean notifyListeners) throws SmackException.NotConnectedException {
        boolean res;
        try {
            res = this.ping(this.connection().getServiceName());
        }
        catch (SmackException.NoResponseException e) {
            res = false;
        }
        if (!res && notifyListeners) {
            for (PingFailedListener l : this.pingFailedListeners) {
                l.pingFailed();
            }
        }
        return res;
    }

    public void setPingInterval(int pingInterval) {
        this.pingInterval = pingInterval;
        this.maybeSchedulePingServerTask();
    }

    public int getPingInterval() {
        return this.pingInterval;
    }

    public void registerPingFailedListener(PingFailedListener listener) {
        this.pingFailedListeners.add(listener);
    }

    public void unregisterPingFailedListener(PingFailedListener listener) {
        this.pingFailedListeners.remove(listener);
    }

    public long getLastReceivedPong() {
        return this.lastPongReceived;
    }

    private void maybeSchedulePingServerTask() {
        this.maybeSchedulePingServerTask(0);
    }

    private synchronized void maybeSchedulePingServerTask(int delta) {
        this.maybeStopPingServerTask();
        if (this.pingInterval > 0) {
            int nextPingIn = this.pingInterval - delta;
            LOGGER.fine("Scheduling ServerPingTask in " + nextPingIn + " seconds (pingInterval=" + this.pingInterval + ", delta=" + delta + ")");
            this.nextAutomaticPing = this.schedule(this.pingServerRunnable, this.pingInterval, TimeUnit.SECONDS);
        }
    }

    private void maybeStopPingServerTask() {
        if (this.nextAutomaticPing != null) {
            this.nextAutomaticPing.cancel(true);
            this.nextAutomaticPing = null;
        }
    }

    static {
        XMPPConnection.addConnectionCreationListener((ConnectionCreationListener)new ConnectionCreationListener(){

            public void connectionCreated(XMPPConnection connection) {
                PingManager.getInstanceFor(connection);
            }
        });
        defaultPingInterval = 1800;
    }
}

