/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.pubsub;

import java.util.ArrayList;
import java.util.List;
import org.jivesoftware.smackx.pubsub.AccessModel;
import org.jivesoftware.smackx.pubsub.ChildrenAssociationPolicy;
import org.jivesoftware.smackx.pubsub.ConfigureNodeFields;
import org.jivesoftware.smackx.pubsub.FormType;
import org.jivesoftware.smackx.pubsub.ItemReply;
import org.jivesoftware.smackx.pubsub.NodeType;
import org.jivesoftware.smackx.pubsub.PublishModel;
import org.jivesoftware.smackx.xdata.Form;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.packet.DataForm;

public class ConfigureForm
extends Form {
    public ConfigureForm(DataForm configDataForm) {
        super(configDataForm);
    }

    public ConfigureForm(Form nodeConfigForm) {
        super(nodeConfigForm.getDataFormToSend());
    }

    public ConfigureForm(FormType formType) {
        super(formType.toString());
    }

    public AccessModel getAccessModel() {
        String value = this.getFieldValue(ConfigureNodeFields.access_model);
        if (value == null) {
            return null;
        }
        return AccessModel.valueOf(value);
    }

    public void setAccessModel(AccessModel accessModel) {
        this.addField(ConfigureNodeFields.access_model, "list-single");
        this.setAnswer(ConfigureNodeFields.access_model.getFieldName(), this.getListSingle(accessModel.toString()));
    }

    public String getBodyXSLT() {
        return this.getFieldValue(ConfigureNodeFields.body_xslt);
    }

    public void setBodyXSLT(String bodyXslt) {
        this.addField(ConfigureNodeFields.body_xslt, "text-single");
        this.setAnswer(ConfigureNodeFields.body_xslt.getFieldName(), bodyXslt);
    }

    public List<String> getChildren() {
        return this.getFieldValues(ConfigureNodeFields.children);
    }

    public void setChildren(List<String> children) {
        this.addField(ConfigureNodeFields.children, "text-multi");
        this.setAnswer(ConfigureNodeFields.children.getFieldName(), children);
    }

    public ChildrenAssociationPolicy getChildrenAssociationPolicy() {
        String value = this.getFieldValue(ConfigureNodeFields.children_association_policy);
        if (value == null) {
            return null;
        }
        return ChildrenAssociationPolicy.valueOf(value);
    }

    public void setChildrenAssociationPolicy(ChildrenAssociationPolicy policy) {
        this.addField(ConfigureNodeFields.children_association_policy, "list-single");
        ArrayList<String> values = new ArrayList<String>(1);
        values.add(policy.toString());
        this.setAnswer(ConfigureNodeFields.children_association_policy.getFieldName(), values);
    }

    public List<String> getChildrenAssociationWhitelist() {
        return this.getFieldValues(ConfigureNodeFields.children_association_whitelist);
    }

    public void setChildrenAssociationWhitelist(List<String> whitelist) {
        this.addField(ConfigureNodeFields.children_association_whitelist, "jid-multi");
        this.setAnswer(ConfigureNodeFields.children_association_whitelist.getFieldName(), whitelist);
    }

    public int getChildrenMax() {
        return Integer.parseInt(this.getFieldValue(ConfigureNodeFields.children_max));
    }

    public void setChildrenMax(int max) {
        this.addField(ConfigureNodeFields.children_max, "text-single");
        this.setAnswer(ConfigureNodeFields.children_max.getFieldName(), max);
    }

    public String getCollection() {
        return this.getFieldValue(ConfigureNodeFields.collection);
    }

    public void setCollection(String collection) {
        this.addField(ConfigureNodeFields.collection, "text-single");
        this.setAnswer(ConfigureNodeFields.collection.getFieldName(), collection);
    }

    public String getDataformXSLT() {
        return this.getFieldValue(ConfigureNodeFields.dataform_xslt);
    }

    public void setDataformXSLT(String url) {
        this.addField(ConfigureNodeFields.dataform_xslt, "text-single");
        this.setAnswer(ConfigureNodeFields.dataform_xslt.getFieldName(), url);
    }

    public boolean isDeliverPayloads() {
        return ConfigureForm.parseBoolean(this.getFieldValue(ConfigureNodeFields.deliver_payloads));
    }

    public void setDeliverPayloads(boolean deliver) {
        this.addField(ConfigureNodeFields.deliver_payloads, "boolean");
        this.setAnswer(ConfigureNodeFields.deliver_payloads.getFieldName(), deliver);
    }

    public ItemReply getItemReply() {
        String value = this.getFieldValue(ConfigureNodeFields.itemreply);
        if (value == null) {
            return null;
        }
        return ItemReply.valueOf(value);
    }

    public void setItemReply(ItemReply reply) {
        this.addField(ConfigureNodeFields.itemreply, "list-single");
        this.setAnswer(ConfigureNodeFields.itemreply.getFieldName(), this.getListSingle(reply.toString()));
    }

    public int getMaxItems() {
        return Integer.parseInt(this.getFieldValue(ConfigureNodeFields.max_items));
    }

    public void setMaxItems(int max) {
        this.addField(ConfigureNodeFields.max_items, "text-single");
        this.setAnswer(ConfigureNodeFields.max_items.getFieldName(), max);
    }

    public int getMaxPayloadSize() {
        return Integer.parseInt(this.getFieldValue(ConfigureNodeFields.max_payload_size));
    }

    public void setMaxPayloadSize(int max) {
        this.addField(ConfigureNodeFields.max_payload_size, "text-single");
        this.setAnswer(ConfigureNodeFields.max_payload_size.getFieldName(), max);
    }

    public NodeType getNodeType() {
        String value = this.getFieldValue(ConfigureNodeFields.node_type);
        if (value == null) {
            return null;
        }
        return NodeType.valueOf(value);
    }

    public void setNodeType(NodeType type) {
        this.addField(ConfigureNodeFields.node_type, "list-single");
        this.setAnswer(ConfigureNodeFields.node_type.getFieldName(), this.getListSingle(type.toString()));
    }

    public boolean isNotifyConfig() {
        return ConfigureForm.parseBoolean(this.getFieldValue(ConfigureNodeFields.notify_config));
    }

    public void setNotifyConfig(boolean notify) {
        this.addField(ConfigureNodeFields.notify_config, "boolean");
        this.setAnswer(ConfigureNodeFields.notify_config.getFieldName(), notify);
    }

    public boolean isNotifyDelete() {
        return ConfigureForm.parseBoolean(this.getFieldValue(ConfigureNodeFields.notify_delete));
    }

    public void setNotifyDelete(boolean notify) {
        this.addField(ConfigureNodeFields.notify_delete, "boolean");
        this.setAnswer(ConfigureNodeFields.notify_delete.getFieldName(), notify);
    }

    public boolean isNotifyRetract() {
        return ConfigureForm.parseBoolean(this.getFieldValue(ConfigureNodeFields.notify_retract));
    }

    public void setNotifyRetract(boolean notify) {
        this.addField(ConfigureNodeFields.notify_retract, "boolean");
        this.setAnswer(ConfigureNodeFields.notify_retract.getFieldName(), notify);
    }

    public boolean isPersistItems() {
        return ConfigureForm.parseBoolean(this.getFieldValue(ConfigureNodeFields.persist_items));
    }

    public void setPersistentItems(boolean persist) {
        this.addField(ConfigureNodeFields.persist_items, "boolean");
        this.setAnswer(ConfigureNodeFields.persist_items.getFieldName(), persist);
    }

    public boolean isPresenceBasedDelivery() {
        return ConfigureForm.parseBoolean(this.getFieldValue(ConfigureNodeFields.presence_based_delivery));
    }

    public void setPresenceBasedDelivery(boolean presenceBased) {
        this.addField(ConfigureNodeFields.presence_based_delivery, "boolean");
        this.setAnswer(ConfigureNodeFields.presence_based_delivery.getFieldName(), presenceBased);
    }

    public PublishModel getPublishModel() {
        String value = this.getFieldValue(ConfigureNodeFields.publish_model);
        if (value == null) {
            return null;
        }
        return PublishModel.valueOf(value);
    }

    public void setPublishModel(PublishModel publish) {
        this.addField(ConfigureNodeFields.publish_model, "list-single");
        this.setAnswer(ConfigureNodeFields.publish_model.getFieldName(), this.getListSingle(publish.toString()));
    }

    public List<String> getReplyRoom() {
        return this.getFieldValues(ConfigureNodeFields.replyroom);
    }

    public void setReplyRoom(List<String> replyRooms) {
        this.addField(ConfigureNodeFields.replyroom, "list-multi");
        this.setAnswer(ConfigureNodeFields.replyroom.getFieldName(), replyRooms);
    }

    public List<String> getReplyTo() {
        return this.getFieldValues(ConfigureNodeFields.replyto);
    }

    public void setReplyTo(List<String> replyTos) {
        this.addField(ConfigureNodeFields.replyto, "list-multi");
        this.setAnswer(ConfigureNodeFields.replyto.getFieldName(), replyTos);
    }

    public List<String> getRosterGroupsAllowed() {
        return this.getFieldValues(ConfigureNodeFields.roster_groups_allowed);
    }

    public void setRosterGroupsAllowed(List<String> groups) {
        this.addField(ConfigureNodeFields.roster_groups_allowed, "list-multi");
        this.setAnswer(ConfigureNodeFields.roster_groups_allowed.getFieldName(), groups);
    }

    public boolean isSubscibe() {
        return ConfigureForm.parseBoolean(this.getFieldValue(ConfigureNodeFields.subscribe));
    }

    public void setSubscribe(boolean subscribe) {
        this.addField(ConfigureNodeFields.subscribe, "boolean");
        this.setAnswer(ConfigureNodeFields.subscribe.getFieldName(), subscribe);
    }

    @Override
    public String getTitle() {
        return this.getFieldValue(ConfigureNodeFields.title);
    }

    @Override
    public void setTitle(String title) {
        this.addField(ConfigureNodeFields.title, "text-single");
        this.setAnswer(ConfigureNodeFields.title.getFieldName(), title);
    }

    public String getDataType() {
        return this.getFieldValue(ConfigureNodeFields.type);
    }

    public void setDataType(String type) {
        this.addField(ConfigureNodeFields.type, "text-single");
        this.setAnswer(ConfigureNodeFields.type.getFieldName(), type);
    }

    public String toString() {
        StringBuilder result = new StringBuilder(this.getClass().getName() + " Content [");
        for (FormField formField : this.getFields()) {
            result.append('(');
            result.append(formField.getVariable());
            result.append(':');
            StringBuilder valuesBuilder = new StringBuilder();
            for (String value : formField.getValues()) {
                if (valuesBuilder.length() > 0) {
                    result.append(',');
                }
                valuesBuilder.append(value);
            }
            if (valuesBuilder.length() == 0) {
                valuesBuilder.append("NOT SET");
            }
            result.append((CharSequence)valuesBuilder);
            result.append(')');
        }
        result.append(']');
        return result.toString();
    }

    private static boolean parseBoolean(String fieldValue) {
        return "1".equals(fieldValue) || "true".equals(fieldValue);
    }

    private String getFieldValue(ConfigureNodeFields field) {
        FormField formField = this.getField(field.getFieldName());
        return formField.getValues().isEmpty() ? null : formField.getValues().get(0);
    }

    private List<String> getFieldValues(ConfigureNodeFields field) {
        FormField formField = this.getField(field.getFieldName());
        return formField.getValues();
    }

    private void addField(ConfigureNodeFields nodeField, String type) {
        String fieldName = nodeField.getFieldName();
        if (this.getField(fieldName) == null) {
            FormField field = new FormField(fieldName);
            field.setType(type);
            this.addField(field);
        }
    }

    private List<String> getListSingle(String value) {
        ArrayList<String> list = new ArrayList<String>(1);
        list.add(value);
        return list;
    }
}

