/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.receipts;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketExtensionFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.receipts.DeliveryReceipt;
import org.jivesoftware.smackx.receipts.DeliveryReceiptRequest;
import org.jivesoftware.smackx.receipts.ReceiptReceivedListener;

public class DeliveryReceiptManager
extends Manager
implements PacketListener {
    private static Map<XMPPConnection, DeliveryReceiptManager> instances = Collections.synchronizedMap(new WeakHashMap());
    private boolean auto_receipts_enabled = false;
    private Set<ReceiptReceivedListener> receiptReceivedListeners = Collections.synchronizedSet(new HashSet());

    private DeliveryReceiptManager(XMPPConnection connection) {
        super(connection);
        ServiceDiscoveryManager sdm = ServiceDiscoveryManager.getInstanceFor(connection);
        sdm.addFeature("urn:xmpp:receipts");
        instances.put(connection, this);
        connection.addPacketListener((PacketListener)this, (PacketFilter)new PacketExtensionFilter("urn:xmpp:receipts"));
    }

    public static synchronized DeliveryReceiptManager getInstanceFor(XMPPConnection connection) {
        DeliveryReceiptManager receiptManager = instances.get(connection);
        if (receiptManager == null) {
            receiptManager = new DeliveryReceiptManager(connection);
        }
        return receiptManager;
    }

    public boolean isSupported(String jid) throws SmackException, XMPPException {
        return ServiceDiscoveryManager.getInstanceFor(this.connection()).supportsFeature(jid, "urn:xmpp:receipts");
    }

    public void processPacket(Packet packet) throws SmackException.NotConnectedException {
        DeliveryReceiptRequest drr;
        DeliveryReceipt dr = (DeliveryReceipt)packet.getExtension("received", "urn:xmpp:receipts");
        if (dr != null) {
            for (ReceiptReceivedListener l : this.receiptReceivedListeners) {
                l.onReceiptReceived(packet.getFrom(), packet.getTo(), dr.getId());
            }
        }
        if (this.auto_receipts_enabled && (drr = (DeliveryReceiptRequest)packet.getExtension("request", "urn:xmpp:receipts")) != null) {
            XMPPConnection connection = this.connection();
            Message ack = new Message(packet.getFrom(), Message.Type.normal);
            ack.addExtension((PacketExtension)new DeliveryReceipt(packet.getPacketID()));
            connection.sendPacket((Packet)ack);
        }
    }

    public void setAutoReceiptsEnabled(boolean new_state) {
        this.auto_receipts_enabled = new_state;
    }

    public void enableAutoReceipts() {
        this.setAutoReceiptsEnabled(true);
    }

    public void disableAutoReceipts() {
        this.setAutoReceiptsEnabled(false);
    }

    public boolean getAutoReceiptsEnabled() {
        return this.auto_receipts_enabled;
    }

    public void addReceiptReceivedListener(ReceiptReceivedListener listener) {
        this.receiptReceivedListeners.add(listener);
    }

    public void removeReceiptReceivedListener(ReceiptReceivedListener listener) {
        this.receiptReceivedListeners.remove(listener);
    }

    public static boolean hasDeliveryReceiptRequest(Packet p) {
        return p.getExtension("request", "urn:xmpp:receipts") != null;
    }

    public static void addDeliveryReceiptRequest(Message m) {
        m.addExtension((PacketExtension)new DeliveryReceiptRequest());
    }

    static {
        XMPPConnection.addConnectionCreationListener((ConnectionCreationListener)new ConnectionCreationListener(){

            public void connectionCreated(XMPPConnection connection) {
                DeliveryReceiptManager.getInstanceFor(connection);
            }
        });
    }
}

