/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.xdata.packet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smackx.xdata.FormField;

public class DataForm
implements PacketExtension {
    private String type;
    private String title;
    private List<String> instructions = new ArrayList<String>();
    private ReportedData reportedData;
    private final List<Item> items = new ArrayList<Item>();
    private final List<FormField> fields = new ArrayList<FormField>();

    public DataForm(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public String getTitle() {
        return this.title;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getInstructions() {
        List<String> list = this.instructions;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList<String>(this.instructions));
        }
    }

    public ReportedData getReportedData() {
        return this.reportedData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Item> getItems() {
        List<Item> list = this.items;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList<Item>(this.items));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FormField> getFields() {
        List<FormField> list = this.fields;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList<FormField>(this.fields));
        }
    }

    public String getElementName() {
        return "x";
    }

    public String getNamespace() {
        return "jabber:x:data";
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setInstructions(List<String> instructions) {
        this.instructions = instructions;
    }

    public void setReportedData(ReportedData reportedData) {
        this.reportedData = reportedData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addField(FormField field) {
        List<FormField> list = this.fields;
        synchronized (list) {
            this.fields.add(field);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInstruction(String instruction) {
        List<String> list = this.instructions;
        synchronized (list) {
            this.instructions.add(instruction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addItem(Item item) {
        List<Item> list = this.items;
        synchronized (list) {
            this.items.add(item);
        }
    }

    public boolean hasHiddenFormTypeField() {
        boolean found = false;
        for (FormField f : this.fields) {
            if (!f.getVariable().equals("FORM_TYPE") || f.getType() == null || !f.getType().equals("hidden")) continue;
            found = true;
        }
        return found;
    }

    public String toXML() {
        StringBuilder buf = new StringBuilder();
        buf.append("<").append(this.getElementName()).append(" xmlns=\"").append(this.getNamespace()).append("\" type=\"" + this.getType() + "\">");
        if (this.getTitle() != null) {
            buf.append("<title>").append(this.getTitle()).append("</title>");
        }
        for (String instruction : this.getInstructions()) {
            buf.append("<instructions>").append(instruction).append("</instructions>");
        }
        if (this.getReportedData() != null) {
            buf.append(this.getReportedData().toXML());
        }
        for (Item item : this.getItems()) {
            buf.append(item.toXML());
        }
        for (FormField field : this.getFields()) {
            buf.append(field.toXML());
        }
        buf.append("</").append(this.getElementName()).append(">");
        return buf.toString();
    }

    public static class Item {
        private List<FormField> fields = new ArrayList<FormField>();

        public Item(List<FormField> fields) {
            this.fields = fields;
        }

        public List<FormField> getFields() {
            return Collections.unmodifiableList(new ArrayList<FormField>(this.fields));
        }

        public String toXML() {
            StringBuilder buf = new StringBuilder();
            buf.append("<item>");
            for (FormField field : this.getFields()) {
                buf.append(field.toXML());
            }
            buf.append("</item>");
            return buf.toString();
        }
    }

    public static class ReportedData {
        private List<FormField> fields = new ArrayList<FormField>();

        public ReportedData(List<FormField> fields) {
            this.fields = fields;
        }

        public List<FormField> getFields() {
            return Collections.unmodifiableList(new ArrayList<FormField>(this.fields));
        }

        public String toXML() {
            StringBuilder buf = new StringBuilder();
            buf.append("<reported>");
            for (FormField field : this.getFields()) {
                buf.append(field.toXML());
            }
            buf.append("</reported>");
            return buf.toString();
        }
    }
}

