/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.caps;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.AbstractConnectionListener;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.PacketInterceptor;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.NotFilter;
import org.jivesoftware.smack.filter.PacketExtensionFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.util.Base64;
import org.jivesoftware.smack.util.Cache;
import org.jivesoftware.smackx.caps.cache.EntityCapsPersistentCache;
import org.jivesoftware.smackx.caps.packet.CapsExtension;
import org.jivesoftware.smackx.disco.NodeInformationProvider;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.disco.packet.DiscoverItems;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.packet.DataForm;

public class EntityCapsManager
extends Manager {
    private static final Logger LOGGER = Logger.getLogger(EntityCapsManager.class.getName());
    public static final String NAMESPACE = "http://jabber.org/protocol/caps";
    public static final String ELEMENT = "c";
    private static final Map<String, MessageDigest> SUPPORTED_HASHES = new HashMap<String, MessageDigest>();
    private static String DEFAULT_ENTITY_NODE = "http://www.igniterealtime.org/projects/smack";
    protected static EntityCapsPersistentCache persistentCache;
    private static boolean autoEnableEntityCaps;
    private static Map<XMPPConnection, EntityCapsManager> instances;
    private static final PacketFilter PRESENCES_WITH_CAPS;
    private static final PacketFilter PRESENCES_WITHOUT_CAPS;
    private static final PacketFilter PRESENCES;
    protected static Map<String, DiscoverInfo> caps;
    protected static Map<String, NodeVerHash> jidCaps;
    private ServiceDiscoveryManager sdm;
    private boolean entityCapsEnabled;
    private String currentCapsVersion;
    private boolean presenceSend = false;
    private Queue<String> lastLocalCapsVersions = new ConcurrentLinkedQueue<String>();
    private String entityNode = DEFAULT_ENTITY_NODE;

    public static void setDefaultEntityNode(String entityNode) {
        DEFAULT_ENTITY_NODE = entityNode;
    }

    public static void addDiscoverInfoByNode(String nodeVer, DiscoverInfo info) {
        caps.put(nodeVer, info);
        if (persistentCache != null) {
            persistentCache.addDiscoverInfoByNodePersistent(nodeVer, info);
        }
    }

    public static String getNodeVersionByJid(String jid) {
        NodeVerHash nvh = jidCaps.get(jid);
        if (nvh != null) {
            return nvh.nodeVer;
        }
        return null;
    }

    public static NodeVerHash getNodeVerHashByJid(String jid) {
        return jidCaps.get(jid);
    }

    public static DiscoverInfo getDiscoverInfoByUser(String user) {
        NodeVerHash nvh = jidCaps.get(user);
        if (nvh == null) {
            return null;
        }
        return EntityCapsManager.getDiscoveryInfoByNodeVer(nvh.nodeVer);
    }

    public static DiscoverInfo getDiscoveryInfoByNodeVer(String nodeVer) {
        DiscoverInfo info = caps.get(nodeVer);
        if (info != null) {
            info = new DiscoverInfo(info);
        }
        return info;
    }

    public static void setPersistentCache(EntityCapsPersistentCache cache) throws IOException {
        if (persistentCache != null) {
            throw new IllegalStateException("Entity Caps Persistent Cache was already set");
        }
        persistentCache = cache;
        persistentCache.replay();
    }

    public static void setJidCapsMaxCacheSize(int maxCacheSize) {
        ((Cache)jidCaps).setMaxCacheSize(maxCacheSize);
    }

    public static void setCapsMaxCacheSize(int maxCacheSize) {
        ((Cache)caps).setMaxCacheSize(maxCacheSize);
    }

    private EntityCapsManager(XMPPConnection connection) {
        super(connection);
        this.sdm = ServiceDiscoveryManager.getInstanceFor(connection);
        instances.put(connection, this);
        connection.addConnectionListener((ConnectionListener)new AbstractConnectionListener(){

            public void connectionClosed() {
                EntityCapsManager.this.presenceSend = false;
            }

            public void connectionClosedOnError(Exception e) {
                EntityCapsManager.this.presenceSend = false;
            }
        });
        this.updateLocalEntityCaps();
        if (autoEnableEntityCaps) {
            this.enableEntityCaps();
        }
        connection.addPacketListener(new PacketListener(){

            public void processPacket(Packet packet) {
                if (!EntityCapsManager.this.entityCapsEnabled()) {
                    return;
                }
                CapsExtension ext = (CapsExtension)packet.getExtension(EntityCapsManager.ELEMENT, EntityCapsManager.NAMESPACE);
                String hash = ext.getHash().toLowerCase(Locale.US);
                if (!SUPPORTED_HASHES.containsKey(hash)) {
                    return;
                }
                String from = packet.getFrom();
                String node = ext.getNode();
                String ver = ext.getVer();
                jidCaps.put(from, new NodeVerHash(node, ver, hash));
            }
        }, PRESENCES_WITH_CAPS);
        connection.addPacketListener(new PacketListener(){

            public void processPacket(Packet packet) {
                String from = packet.getFrom();
                jidCaps.remove(from);
            }
        }, PRESENCES_WITHOUT_CAPS);
        connection.addPacketSendingListener(new PacketListener(){

            public void processPacket(Packet packet) {
                EntityCapsManager.this.presenceSend = true;
            }
        }, PRESENCES);
        PacketInterceptor packetInterceptor = new PacketInterceptor(){

            public void interceptPacket(Packet packet) {
                if (!EntityCapsManager.this.entityCapsEnabled) {
                    return;
                }
                CapsExtension caps = new CapsExtension(EntityCapsManager.this.entityNode, EntityCapsManager.this.getCapsVersion(), "sha-1");
                packet.addExtension((PacketExtension)caps);
            }
        };
        connection.addPacketInterceptor(packetInterceptor, PRESENCES);
        this.sdm.setEntityCapsManager(this);
    }

    public static synchronized EntityCapsManager getInstanceFor(XMPPConnection connection) {
        if (SUPPORTED_HASHES.size() <= 0) {
            throw new IllegalStateException("No supported hashes for EntityCapsManager");
        }
        EntityCapsManager entityCapsManager = instances.get(connection);
        if (entityCapsManager == null) {
            entityCapsManager = new EntityCapsManager(connection);
        }
        return entityCapsManager;
    }

    public synchronized void enableEntityCaps() {
        this.sdm.addFeature(NAMESPACE);
        this.updateLocalEntityCaps();
        this.entityCapsEnabled = true;
    }

    public synchronized void disableEntityCaps() {
        this.entityCapsEnabled = false;
        this.sdm.removeFeature(NAMESPACE);
    }

    public boolean entityCapsEnabled() {
        return this.entityCapsEnabled;
    }

    public void setEntityNode(String entityNode) throws SmackException.NotConnectedException {
        this.entityNode = entityNode;
        this.updateLocalEntityCaps();
    }

    public void removeUserCapsNode(String user) {
        jidCaps.remove(user);
    }

    public String getCapsVersion() {
        return this.currentCapsVersion;
    }

    public String getLocalNodeVer() {
        return this.entityNode + '#' + this.getCapsVersion();
    }

    public boolean areEntityCapsSupported(String jid) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        return this.sdm.supportsFeature(jid, NAMESPACE);
    }

    public boolean areEntityCapsSupportedByServer() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        return this.areEntityCapsSupported(this.connection().getServiceName());
    }

    public void updateLocalEntityCaps() {
        XMPPConnection connection = this.connection();
        DiscoverInfo discoverInfo = new DiscoverInfo();
        discoverInfo.setType(IQ.Type.RESULT);
        discoverInfo.setNode(this.getLocalNodeVer());
        if (connection != null) {
            discoverInfo.setFrom(connection.getUser());
        }
        this.sdm.addDiscoverInfoTo(discoverInfo);
        this.currentCapsVersion = EntityCapsManager.generateVerificationString(discoverInfo, "sha-1");
        EntityCapsManager.addDiscoverInfoByNode(this.entityNode + '#' + this.currentCapsVersion, discoverInfo);
        if (this.lastLocalCapsVersions.size() > 10) {
            String oldCapsVersion = this.lastLocalCapsVersions.poll();
            this.sdm.removeNodeInformationProvider(this.entityNode + '#' + oldCapsVersion);
        }
        this.lastLocalCapsVersions.add(this.currentCapsVersion);
        caps.put(this.currentCapsVersion, discoverInfo);
        if (connection != null) {
            jidCaps.put(connection.getUser(), new NodeVerHash(this.entityNode, this.currentCapsVersion, "sha-1"));
        }
        final LinkedList<DiscoverInfo.Identity> identities = new LinkedList<DiscoverInfo.Identity>(ServiceDiscoveryManager.getInstanceFor(connection).getIdentities());
        this.sdm.setNodeInformationProvider(this.entityNode + '#' + this.currentCapsVersion, new NodeInformationProvider(){
            List<String> features;
            List<PacketExtension> packetExtensions;
            {
                this.features = EntityCapsManager.this.sdm.getFeaturesList();
                this.packetExtensions = EntityCapsManager.this.sdm.getExtendedInfoAsList();
            }

            @Override
            public List<DiscoverItems.Item> getNodeItems() {
                return null;
            }

            @Override
            public List<String> getNodeFeatures() {
                return this.features;
            }

            @Override
            public List<DiscoverInfo.Identity> getNodeIdentities() {
                return identities;
            }

            @Override
            public List<PacketExtension> getNodePacketExtensions() {
                return this.packetExtensions;
            }
        });
        if (connection != null && connection.isAuthenticated() && this.presenceSend) {
            Presence presence = new Presence(Presence.Type.available);
            try {
                connection.sendPacket((Packet)presence);
            }
            catch (SmackException.NotConnectedException e) {
                LOGGER.log(Level.WARNING, "Could could not update presence with caps info", e);
            }
        }
    }

    public static boolean verifyDiscoverInfoVersion(String ver, String hash, DiscoverInfo info) {
        if (info.containsDuplicateIdentities()) {
            return false;
        }
        if (info.containsDuplicateFeatures()) {
            return false;
        }
        if (EntityCapsManager.verifyPacketExtensions(info)) {
            return false;
        }
        String calculatedVer = EntityCapsManager.generateVerificationString(info, hash);
        return ver.equals(calculatedVer);
    }

    protected static boolean verifyPacketExtensions(DiscoverInfo info) {
        LinkedList<FormField> foundFormTypes = new LinkedList<FormField>();
        for (PacketExtension pe : info.getExtensions()) {
            if (!pe.getNamespace().equals("jabber:x:data")) continue;
            DataForm df = (DataForm)pe;
            for (FormField f : df.getFields()) {
                if (!f.getVariable().equals("FORM_TYPE")) continue;
                for (FormField fft : foundFormTypes) {
                    if (!f.equals(fft)) continue;
                    return true;
                }
                foundFormTypes.add(f);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String generateVerificationString(DiscoverInfo discoverInfo, String hash) {
        MessageDigest md = SUPPORTED_HASHES.get(hash.toLowerCase(Locale.US));
        if (md == null) {
            return null;
        }
        DataForm extendedInfo = (DataForm)discoverInfo.getExtension("x", "jabber:x:data");
        StringBuilder sb = new StringBuilder();
        TreeSet<DiscoverInfo.Identity> sortedIdentities = new TreeSet<DiscoverInfo.Identity>();
        for (DiscoverInfo.Identity i : discoverInfo.getIdentities()) {
            sortedIdentities.add(i);
        }
        for (DiscoverInfo.Identity identity : sortedIdentities) {
            sb.append(identity.getCategory());
            sb.append("/");
            sb.append(identity.getType());
            sb.append("/");
            sb.append(identity.getLanguage() == null ? "" : identity.getLanguage());
            sb.append("/");
            sb.append(identity.getName() == null ? "" : identity.getName());
            sb.append("<");
        }
        TreeSet<String> features = new TreeSet<String>();
        for (DiscoverInfo.Feature feature : discoverInfo.getFeatures()) {
            features.add(feature.getVar());
        }
        for (String string : features) {
            sb.append(string);
            sb.append("<");
        }
        if (extendedInfo != null && extendedInfo.hasHiddenFormTypeField()) {
            DataForm i$ = extendedInfo;
            synchronized (i$) {
                TreeSet<FormField> treeSet = new TreeSet<FormField>(new Comparator<FormField>(){

                    @Override
                    public int compare(FormField f1, FormField f2) {
                        return f1.getVariable().compareTo(f2.getVariable());
                    }
                });
                FormField ft = null;
                for (FormField f : extendedInfo.getFields()) {
                    if (!f.getVariable().equals("FORM_TYPE")) {
                        treeSet.add(f);
                        continue;
                    }
                    ft = f;
                }
                if (ft != null) {
                    EntityCapsManager.formFieldValuesToCaps(ft.getValues(), sb);
                }
                for (FormField f : treeSet) {
                    sb.append(f.getVariable());
                    sb.append("<");
                    EntityCapsManager.formFieldValuesToCaps(f.getValues(), sb);
                }
            }
        }
        byte[] digest = md.digest(sb.toString().getBytes());
        return Base64.encodeBytes((byte[])digest);
    }

    private static void formFieldValuesToCaps(List<String> i, StringBuilder sb) {
        TreeSet<String> fvs = new TreeSet<String>();
        for (String s : i) {
            fvs.add(s);
        }
        for (String fv : fvs) {
            sb.append(fv);
            sb.append("<");
        }
    }

    static {
        autoEnableEntityCaps = true;
        instances = Collections.synchronizedMap(new WeakHashMap());
        PRESENCES_WITH_CAPS = new AndFilter(new PacketFilter[]{new PacketTypeFilter(Presence.class), new PacketExtensionFilter(ELEMENT, NAMESPACE)});
        PRESENCES_WITHOUT_CAPS = new AndFilter(new PacketFilter[]{new PacketTypeFilter(Presence.class), new NotFilter((PacketFilter)new PacketExtensionFilter(ELEMENT, NAMESPACE))});
        PRESENCES = new PacketTypeFilter(Presence.class);
        caps = new Cache(1000, -1L);
        jidCaps = new Cache(10000, -1L);
        XMPPConnection.addConnectionCreationListener((ConnectionCreationListener)new ConnectionCreationListener(){

            public void connectionCreated(XMPPConnection connection) {
                EntityCapsManager.getInstanceFor(connection);
            }
        });
        try {
            MessageDigest sha1MessageDigest = MessageDigest.getInstance("SHA-1");
            SUPPORTED_HASHES.put("sha-1", sha1MessageDigest);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
    }

    public static class NodeVerHash {
        private String node;
        private String hash;
        private String ver;
        private String nodeVer;

        NodeVerHash(String node, String ver, String hash) {
            this.node = node;
            this.ver = ver;
            this.hash = hash;
            this.nodeVer = node + "#" + ver;
        }

        public String getNodeVer() {
            return this.nodeVer;
        }

        public String getNode() {
            return this.node;
        }

        public String getHash() {
            return this.hash;
        }

        public String getVer() {
            return this.ver;
        }
    }
}

