/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.xdata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jivesoftware.smack.util.XmlStringBuilder;

public class FormField {
    public static final String ELEMENT = "field";
    public static final String TYPE_BOOLEAN = "boolean";
    public static final String TYPE_FIXED = "fixed";
    public static final String TYPE_HIDDEN = "hidden";
    public static final String TYPE_JID_MULTI = "jid-multi";
    public static final String TYPE_JID_SINGLE = "jid-single";
    public static final String TYPE_LIST_MULTI = "list-multi";
    public static final String TYPE_LIST_SINGLE = "list-single";
    public static final String TYPE_TEXT_MULTI = "text-multi";
    public static final String TYPE_TEXT_PRIVATE = "text-private";
    public static final String TYPE_TEXT_SINGLE = "text-single";
    private String description;
    private boolean required = false;
    private String label;
    private String variable;
    private String type;
    private final List<Option> options = new ArrayList<Option>();
    private final List<String> values = new ArrayList<String>();

    public FormField(String variable) {
        this.variable = variable;
    }

    public FormField() {
        this.type = TYPE_FIXED;
    }

    public String getDescription() {
        return this.description;
    }

    public String getLabel() {
        return this.label;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Option> getOptions() {
        List<Option> list = this.options;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList<Option>(this.options));
        }
    }

    public boolean isRequired() {
        return this.required;
    }

    public String getType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getValues() {
        List<String> list = this.values;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList<String>(this.values));
        }
    }

    public String getVariable() {
        return this.variable;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public void setType(String type) {
        this.type = type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addValue(String value) {
        List<String> list = this.values;
        synchronized (list) {
            this.values.add(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addValues(List<String> newValues) {
        List<String> list = this.values;
        synchronized (list) {
            this.values.addAll(newValues);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetValues() {
        List<String> list = this.values;
        synchronized (list) {
            this.values.removeAll(new ArrayList<String>(this.values));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOption(Option option) {
        List<Option> list = this.options;
        synchronized (list) {
            this.options.add(option);
        }
    }

    public XmlStringBuilder toXML() {
        XmlStringBuilder buf = new XmlStringBuilder();
        buf.halfOpenElement(ELEMENT);
        buf.optAttribute("label", this.getLabel());
        buf.optAttribute("var", this.getVariable());
        buf.optAttribute("type", this.getType());
        buf.rightAngelBracket();
        buf.optElement("desc", this.getDescription());
        buf.condEmptyElement(this.isRequired(), "required");
        for (String value : this.getValues()) {
            buf.element("value", value);
        }
        for (Option option : this.getOptions()) {
            buf.append(option.toXML());
        }
        buf.closeElement(ELEMENT);
        return buf;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FormField)) {
            return false;
        }
        FormField other = (FormField)obj;
        return this.toXML().equals((Object)other.toXML());
    }

    public int hashCode() {
        return this.toXML().hashCode();
    }

    public static class Option {
        public static final String ELEMNT = "option";
        private final String value;
        private String label;

        public Option(String value) {
            this.value = value;
        }

        public Option(String label, String value) {
            this.label = label;
            this.value = value;
        }

        public String getLabel() {
            return this.label;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.getLabel();
        }

        public XmlStringBuilder toXML() {
            XmlStringBuilder xml = new XmlStringBuilder();
            xml.halfOpenElement(ELEMNT);
            xml.optAttribute("label", this.getLabel());
            xml.rightAngelBracket();
            xml.element("value", this.getValue());
            xml.closeElement(FormField.ELEMENT);
            return xml;
        }

        public boolean equals(Object obj) {
            String otherLabel;
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            Option other = (Option)obj;
            if (!this.value.equals(other.value)) {
                return false;
            }
            String thisLabel = this.label == null ? "" : this.label;
            String string = otherLabel = other.label == null ? "" : other.label;
            return thisLabel.equals(otherLabel);
        }

        public int hashCode() {
            int result = 1;
            result = 37 * result + this.value.hashCode();
            result = 37 * result + (this.label == null ? 0 : this.label.hashCode());
            return result;
        }
    }
}

