/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.pubsub;

import java.util.Collections;
import java.util.List;
import org.jivesoftware.smackx.pubsub.NodeExtension;
import org.jivesoftware.smackx.pubsub.PubSubElementType;
import org.jivesoftware.smackx.pubsub.Subscription;

public class SubscriptionsExtension
extends NodeExtension {
    protected List<Subscription> items = Collections.emptyList();

    public SubscriptionsExtension(List<Subscription> subList) {
        super(PubSubElementType.SUBSCRIPTIONS);
        if (subList != null) {
            this.items = subList;
        }
    }

    public SubscriptionsExtension(String nodeId, List<Subscription> subList) {
        super(PubSubElementType.SUBSCRIPTIONS, nodeId);
        if (subList != null) {
            this.items = subList;
        }
    }

    public List<Subscription> getSubscriptions() {
        return this.items;
    }

    @Override
    public CharSequence toXML() {
        if (this.items == null || this.items.size() == 0) {
            return super.toXML();
        }
        StringBuilder builder = new StringBuilder("<");
        builder.append(this.getElementName());
        if (this.getNode() != null) {
            builder.append(" node='");
            builder.append(this.getNode());
            builder.append("'");
        }
        builder.append(">");
        for (Subscription item : this.items) {
            builder.append(item.toXML());
        }
        builder.append("</");
        builder.append(this.getElementName());
        builder.append(">");
        return builder.toString();
    }
}

