/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.disco.packet;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.util.XmlStringBuilder;

public class DiscoverInfo
extends IQ
implements Cloneable {
    public static final String NAMESPACE = "http://jabber.org/protocol/disco#info";
    private final List<Feature> features = new LinkedList<Feature>();
    private final List<Identity> identities = new LinkedList<Identity>();
    private String node;

    public DiscoverInfo() {
    }

    public DiscoverInfo(DiscoverInfo d) {
        super((IQ)d);
        this.setNode(d.getNode());
        for (Feature f : d.features) {
            this.addFeature(f.clone());
        }
        for (Identity i : d.identities) {
            this.addIdentity(i.clone());
        }
    }

    public void addFeature(String feature) {
        this.addFeature(new Feature(feature));
    }

    public void addFeatures(Collection<String> featuresToAdd) {
        if (featuresToAdd == null) {
            return;
        }
        for (String feature : featuresToAdd) {
            this.addFeature(feature);
        }
    }

    private void addFeature(Feature feature) {
        this.features.add(feature);
    }

    public List<Feature> getFeatures() {
        return Collections.unmodifiableList(this.features);
    }

    public void addIdentity(Identity identity) {
        this.identities.add(identity);
    }

    public void addIdentities(Collection<Identity> identitiesToAdd) {
        if (identitiesToAdd == null) {
            return;
        }
        this.identities.addAll(identitiesToAdd);
    }

    public List<Identity> getIdentities() {
        return Collections.unmodifiableList(this.identities);
    }

    public String getNode() {
        return this.node;
    }

    public void setNode(String node) {
        this.node = node;
    }

    public boolean containsFeature(String feature) {
        for (Feature f : this.getFeatures()) {
            if (!feature.equals(f.getVar())) continue;
            return true;
        }
        return false;
    }

    public CharSequence getChildElementXML() {
        XmlStringBuilder xml = new XmlStringBuilder();
        xml.halfOpenElement("query");
        xml.xmlnsAttribute(NAMESPACE);
        xml.optAttribute("node", this.getNode());
        xml.rightAngelBracket();
        for (Identity identity : this.identities) {
            xml.append(identity.toXML());
        }
        for (Feature feature : this.features) {
            xml.append(feature.toXML());
        }
        xml.append(this.getExtensionsXML());
        xml.closeElement("query");
        return xml;
    }

    public boolean containsDuplicateIdentities() {
        LinkedList<Identity> checkedIdentities = new LinkedList<Identity>();
        for (Identity i : this.identities) {
            for (Identity i2 : checkedIdentities) {
                if (!i.equals(i2)) continue;
                return true;
            }
            checkedIdentities.add(i);
        }
        return false;
    }

    public boolean containsDuplicateFeatures() {
        LinkedList<Feature> checkedFeatures = new LinkedList<Feature>();
        for (Feature f : this.features) {
            for (Feature f2 : checkedFeatures) {
                if (!f.equals(f2)) continue;
                return true;
            }
            checkedFeatures.add(f);
        }
        return false;
    }

    public DiscoverInfo clone() {
        return new DiscoverInfo(this);
    }

    public static class Feature
    implements Cloneable {
        private final String variable;

        public Feature(Feature feature) {
            this.variable = feature.variable;
        }

        public Feature(String variable) {
            if (variable == null) {
                throw new IllegalArgumentException("variable cannot be null");
            }
            this.variable = variable;
        }

        public String getVar() {
            return this.variable;
        }

        public XmlStringBuilder toXML() {
            XmlStringBuilder xml = new XmlStringBuilder();
            xml.halfOpenElement("feature");
            xml.attribute("var", this.variable);
            xml.closeEmptyElement();
            return xml;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            Feature other = (Feature)obj;
            return this.variable.equals(other.variable);
        }

        public int hashCode() {
            return 37 * this.variable.hashCode();
        }

        public Feature clone() {
            return new Feature(this);
        }
    }

    public static class Identity
    implements Comparable<Identity>,
    Cloneable {
        private final String category;
        private String name;
        private final String type;
        private String lang;

        public Identity(Identity identity) {
            this(identity.category, identity.name, identity.type);
            this.lang = identity.lang;
        }

        public Identity(String category, String name, String type) {
            if (category == null || type == null) {
                throw new IllegalArgumentException("category and type cannot be null");
            }
            this.category = category;
            this.name = name;
            this.type = type;
        }

        public String getCategory() {
            return this.category;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public void setLanguage(String lang) {
            this.lang = lang;
        }

        public String getLanguage() {
            return this.lang;
        }

        public XmlStringBuilder toXML() {
            XmlStringBuilder xml = new XmlStringBuilder();
            xml.halfOpenElement("identity");
            xml.xmllangAttribute(this.lang);
            xml.attribute("category", this.category);
            xml.optAttribute("name", this.name);
            xml.optAttribute("type", this.type);
            xml.closeEmptyElement();
            return xml;
        }

        public boolean equals(Object obj) {
            String thisName;
            String thisType;
            String thisLang;
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            Identity other = (Identity)obj;
            if (!this.category.equals(other.category)) {
                return false;
            }
            String otherLang = other.lang == null ? "" : other.lang;
            String string = thisLang = this.lang == null ? "" : this.lang;
            if (!otherLang.equals(thisLang)) {
                return false;
            }
            String otherType = other.type == null ? "" : other.type;
            String string2 = thisType = this.type == null ? "" : this.type;
            if (!otherType.equals(thisType)) {
                return false;
            }
            String otherName = other.name == null ? "" : other.name;
            String string3 = thisName = this.name == null ? "" : other.name;
            return thisName.equals(otherName);
        }

        public int hashCode() {
            int result = 1;
            result = 37 * result + this.category.hashCode();
            result = 37 * result + (this.lang == null ? 0 : this.lang.hashCode());
            result = 37 * result + (this.type == null ? 0 : this.type.hashCode());
            result = 37 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        @Override
        public int compareTo(Identity other) {
            String thisType;
            String otherLang = other.lang == null ? "" : other.lang;
            String thisLang = this.lang == null ? "" : this.lang;
            String otherType = other.type == null ? "" : other.type;
            String string = thisType = this.type == null ? "" : this.type;
            if (this.category.equals(other.category)) {
                if (thisType.equals(otherType)) {
                    if (thisLang.equals(otherLang)) {
                        return 0;
                    }
                    return thisLang.compareTo(otherLang);
                }
                return thisType.compareTo(otherType);
            }
            return this.category.compareTo(other.category);
        }

        public Identity clone() {
            return new Identity(this);
        }
    }
}

