/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc;

import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smackx.muc.PacketMultiplexListener;
import org.jxmpp.util.XmppStringUtils;

class RoomListenerMultiplexor
extends Manager {
    private static final Map<XMPPConnection, RoomListenerMultiplexor> monitors = new WeakHashMap<XMPPConnection, RoomListenerMultiplexor>();
    private final RoomMultiplexFilter filter;
    private final RoomMultiplexListener listener;

    public static synchronized RoomListenerMultiplexor getRoomMultiplexor(XMPPConnection conn) {
        RoomListenerMultiplexor rlm = monitors.get(conn);
        if (rlm == null) {
            rlm = new RoomListenerMultiplexor(conn, new RoomMultiplexFilter(), new RoomMultiplexListener());
        }
        return rlm;
    }

    private RoomListenerMultiplexor(XMPPConnection connection, RoomMultiplexFilter filter, RoomMultiplexListener listener) {
        super(connection);
        connection.addPacketListener((PacketListener)listener, (PacketFilter)filter);
        this.filter = filter;
        this.listener = listener;
        monitors.put(connection, this);
    }

    public void addRoom(String address, PacketMultiplexListener roomListener) {
        this.filter.addRoom(address);
        this.listener.addRoom(address, roomListener);
    }

    public void removeRoom(String address) {
        this.filter.removeRoom(address);
        this.listener.removeRoom(address);
    }

    private static class RoomMultiplexListener
    implements PacketListener {
        private Map<String, PacketMultiplexListener> roomListenersByAddress = new ConcurrentHashMap<String, PacketMultiplexListener>();

        private RoomMultiplexListener() {
        }

        public void processPacket(Packet p) throws SmackException.NotConnectedException {
            String from = p.getFrom();
            if (from == null) {
                return;
            }
            PacketMultiplexListener listener = this.roomListenersByAddress.get(XmppStringUtils.parseBareAddress((String)from).toLowerCase(Locale.US));
            if (listener != null) {
                listener.processPacket(p);
            }
        }

        public void addRoom(String address, PacketMultiplexListener listener) {
            if (address == null) {
                return;
            }
            this.roomListenersByAddress.put(address.toLowerCase(Locale.US), listener);
        }

        public void removeRoom(String address) {
            if (address == null) {
                return;
            }
            this.roomListenersByAddress.remove(address.toLowerCase(Locale.US));
        }
    }

    private static class RoomMultiplexFilter
    implements PacketFilter {
        private Map<String, String> roomAddressTable = new ConcurrentHashMap<String, String>();

        private RoomMultiplexFilter() {
        }

        public boolean accept(Packet p) {
            String from = p.getFrom();
            if (from == null) {
                return false;
            }
            return this.roomAddressTable.containsKey(XmppStringUtils.parseBareAddress((String)from).toLowerCase(Locale.US));
        }

        public void addRoom(String address) {
            if (address == null) {
                return;
            }
            this.roomAddressTable.put(address.toLowerCase(Locale.US), address);
        }

        public void removeRoom(String address) {
            if (address == null) {
                return;
            }
            this.roomAddressTable.remove(address.toLowerCase(Locale.US));
        }
    }
}

