/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.iqversion;

import java.util.Map;
import java.util.WeakHashMap;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.IQTypeFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.iqversion.packet.Version;

public class VersionManager
extends Manager {
    private static final Map<XMPPConnection, VersionManager> INSTANCES = new WeakHashMap<XMPPConnection, VersionManager>();
    private static final PacketFilter PACKET_FILTER = new AndFilter(new PacketFilter[]{new PacketTypeFilter(Version.class), IQTypeFilter.GET});
    private static Version defaultVersion;
    private Version ourVersion = defaultVersion;
    private static boolean autoAppendSmackVersion;

    public static void setDefaultVersion(String name, String version) {
        VersionManager.setDefaultVersion(name, version, null);
    }

    public static void setDefaultVersion(String name, String version, String os) {
        defaultVersion = VersionManager.generateVersionFrom(name, version, os);
    }

    private VersionManager(XMPPConnection connection) {
        super(connection);
        ServiceDiscoveryManager sdm = ServiceDiscoveryManager.getInstanceFor(connection);
        sdm.addFeature("jabber:iq:version");
        connection.addPacketListener(new PacketListener(){

            public void processPacket(Packet packet) throws SmackException.NotConnectedException {
                if (VersionManager.this.ourVersion == null) {
                    return;
                }
                VersionManager.this.connection().sendPacket((Packet)Version.createResultFor(packet, VersionManager.this.ourVersion));
            }
        }, PACKET_FILTER);
    }

    public static synchronized VersionManager getInstanceFor(XMPPConnection connection) {
        VersionManager versionManager = INSTANCES.get(connection);
        if (versionManager == null) {
            versionManager = new VersionManager(connection);
            INSTANCES.put(connection, versionManager);
        }
        return versionManager;
    }

    public static void setAutoAppendSmackVersion(boolean autoAppendSmackVersion) {
        VersionManager.autoAppendSmackVersion = autoAppendSmackVersion;
    }

    public void setVersion(String name, String version) {
        this.setVersion(name, version, null);
    }

    public void setVersion(String name, String version, String os) {
        this.ourVersion = VersionManager.generateVersionFrom(name, version, os);
    }

    public void unsetVersion() {
        this.ourVersion = null;
    }

    public boolean isSupported(String jid) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        return ServiceDiscoveryManager.getInstanceFor(this.connection()).supportsFeature(jid, "jabber:iq:version");
    }

    public Version getVersion(String jid) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        if (!this.isSupported(jid)) {
            return null;
        }
        return (Version)this.connection().createPacketCollectorAndSend((IQ)new Version(jid)).nextResultOrThrow();
    }

    private static Version generateVersionFrom(String name, String version, String os) {
        if (autoAppendSmackVersion) {
            name = name + " (Smack " + SmackConfiguration.getVersion() + ')';
        }
        return new Version(name, version, os);
    }

    static {
        autoAppendSmackVersion = true;
        XMPPConnectionRegistry.addConnectionCreationListener((ConnectionCreationListener)new ConnectionCreationListener(){

            public void connectionCreated(XMPPConnection connection) {
                VersionManager.getInstanceFor(connection);
            }
        });
    }
}

