/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.filetransfer;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smackx.filetransfer.FileTransfer;
import org.jivesoftware.smackx.filetransfer.FileTransferNegotiator;
import org.jivesoftware.smackx.filetransfer.FileTransferRequest;
import org.jivesoftware.smackx.filetransfer.StreamNegotiator;

public class IncomingFileTransfer
extends FileTransfer {
    private static final Logger LOGGER = Logger.getLogger(IncomingFileTransfer.class.getName());
    private FileTransferRequest recieveRequest;
    private InputStream inputStream;

    protected IncomingFileTransfer(FileTransferRequest request, FileTransferNegotiator transferNegotiator) {
        super(request.getRequestor(), request.getStreamID(), transferNegotiator);
        this.recieveRequest = request;
    }

    public InputStream recieveFile() throws SmackException, XMPPException.XMPPErrorException {
        if (this.inputStream != null) {
            throw new IllegalStateException("Transfer already negotiated!");
        }
        try {
            this.inputStream = this.negotiateStream();
        }
        catch (XMPPException.XMPPErrorException e) {
            this.setException((Exception)((Object)e));
            throw e;
        }
        return this.inputStream;
    }

    public void recieveFile(final File file) throws SmackException, IOException {
        if (file == null) {
            throw new IllegalArgumentException("File cannot be null");
        }
        if (!file.exists()) {
            file.createNewFile();
        }
        if (!file.canWrite()) {
            throw new IllegalArgumentException("Cannot write to provided file");
        }
        Thread transferThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    IncomingFileTransfer.this.inputStream = IncomingFileTransfer.this.negotiateStream();
                }
                catch (Exception e) {
                    IncomingFileTransfer.this.setStatus(FileTransfer.Status.error);
                    IncomingFileTransfer.this.setException(e);
                    return;
                }
                FileOutputStream outputStream = null;
                try {
                    outputStream = new FileOutputStream(file);
                    IncomingFileTransfer.this.setStatus(FileTransfer.Status.in_progress);
                    IncomingFileTransfer.this.writeToStream(IncomingFileTransfer.this.inputStream, outputStream);
                }
                catch (FileNotFoundException e) {
                    IncomingFileTransfer.this.setStatus(FileTransfer.Status.error);
                    IncomingFileTransfer.this.setError(FileTransfer.Error.bad_file);
                    IncomingFileTransfer.this.setException(e);
                }
                catch (IOException e) {
                    IncomingFileTransfer.this.setStatus(FileTransfer.Status.error);
                    IncomingFileTransfer.this.setError(FileTransfer.Error.stream);
                    IncomingFileTransfer.this.setException(e);
                }
                if (IncomingFileTransfer.this.getStatus().equals((Object)FileTransfer.Status.in_progress)) {
                    IncomingFileTransfer.this.setStatus(FileTransfer.Status.complete);
                }
                if (IncomingFileTransfer.this.inputStream != null) {
                    try {
                        IncomingFileTransfer.this.inputStream.close();
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.WARNING, "Closing input stream", e);
                    }
                }
                if (outputStream != null) {
                    try {
                        ((OutputStream)outputStream).close();
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.WARNING, "Closing output stream", e);
                    }
                }
            }
        }, "File Transfer " + this.streamID);
        transferThread.start();
    }

    private InputStream negotiateStream() throws SmackException, XMPPException.XMPPErrorException {
        InputStream inputStream;
        this.setStatus(FileTransfer.Status.negotiating_transfer);
        final StreamNegotiator streamNegotiator = this.negotiator.selectStreamNegotiator(this.recieveRequest);
        this.setStatus(FileTransfer.Status.negotiating_stream);
        FutureTask<InputStream> streamNegotiatorTask = new FutureTask<InputStream>(new Callable<InputStream>(){

            @Override
            public InputStream call() throws Exception {
                return streamNegotiator.createIncomingStream(IncomingFileTransfer.this.recieveRequest.getStreamInitiation());
            }
        });
        streamNegotiatorTask.run();
        try {
            inputStream = streamNegotiatorTask.get(15L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new SmackException("Interruption while executing", (Throwable)e);
        }
        catch (ExecutionException e) {
            throw new SmackException("Error in execution", (Throwable)e);
        }
        catch (TimeoutException e) {
            throw new SmackException("Request timed out", (Throwable)e);
        }
        finally {
            streamNegotiatorTask.cancel(true);
        }
        this.setStatus(FileTransfer.Status.negotiated);
        return inputStream;
    }

    @Override
    public void cancel() {
        this.setStatus(FileTransfer.Status.cancelled);
    }
}

