/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.filetransfer;

import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Random;
import java.util.WeakHashMap;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.filetransfer.FaultTolerantNegotiator;
import org.jivesoftware.smackx.filetransfer.FileTransferRequest;
import org.jivesoftware.smackx.filetransfer.IBBTransferNegotiator;
import org.jivesoftware.smackx.filetransfer.Socks5TransferNegotiator;
import org.jivesoftware.smackx.filetransfer.StreamNegotiator;
import org.jivesoftware.smackx.si.packet.StreamInitiation;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.packet.DataForm;

public class FileTransferNegotiator
extends Manager {
    public static final String SI_NAMESPACE = "http://jabber.org/protocol/si";
    public static final String SI_PROFILE_FILE_TRANSFER_NAMESPACE = "http://jabber.org/protocol/si/profile/file-transfer";
    private static final String[] NAMESPACE = new String[]{"http://jabber.org/protocol/si", "http://jabber.org/protocol/si/profile/file-transfer"};
    private static final Map<XMPPConnection, FileTransferNegotiator> INSTANCES = new WeakHashMap<XMPPConnection, FileTransferNegotiator>();
    private static final String STREAM_INIT_PREFIX = "jsi_";
    protected static final String STREAM_DATA_FIELD_NAME = "stream-method";
    private static final Random randomGenerator = new Random();
    public static boolean IBB_ONLY = System.getProperty("ibb") != null;
    private final StreamNegotiator byteStreamTransferManager;
    private final StreamNegotiator inbandTransferManager;

    public static synchronized FileTransferNegotiator getInstanceFor(XMPPConnection connection) {
        FileTransferNegotiator fileTransferNegotiator = INSTANCES.get(connection);
        if (fileTransferNegotiator == null) {
            fileTransferNegotiator = new FileTransferNegotiator(connection);
            INSTANCES.put(connection, fileTransferNegotiator);
        }
        return fileTransferNegotiator;
    }

    private static void setServiceEnabled(XMPPConnection connection, boolean isEnabled) {
        ServiceDiscoveryManager manager = ServiceDiscoveryManager.getInstanceFor(connection);
        ArrayList<String> namespaces = new ArrayList<String>();
        namespaces.addAll(Arrays.asList(NAMESPACE));
        namespaces.add("http://jabber.org/protocol/ibb");
        if (!IBB_ONLY) {
            namespaces.add("http://jabber.org/protocol/bytestreams");
        }
        for (String namespace : namespaces) {
            if (isEnabled) {
                manager.addFeature(namespace);
                continue;
            }
            manager.removeFeature(namespace);
        }
    }

    public static boolean isServiceEnabled(XMPPConnection connection) {
        ServiceDiscoveryManager manager = ServiceDiscoveryManager.getInstanceFor(connection);
        ArrayList<String> namespaces = new ArrayList<String>();
        namespaces.addAll(Arrays.asList(NAMESPACE));
        namespaces.add("http://jabber.org/protocol/ibb");
        if (!IBB_ONLY) {
            namespaces.add("http://jabber.org/protocol/bytestreams");
        }
        for (String namespace : namespaces) {
            if (manager.includesFeature(namespace)) continue;
            return false;
        }
        return true;
    }

    public static Collection<String> getSupportedProtocols() {
        ArrayList<String> protocols = new ArrayList<String>();
        protocols.add("http://jabber.org/protocol/ibb");
        if (!IBB_ONLY) {
            protocols.add("http://jabber.org/protocol/bytestreams");
        }
        return Collections.unmodifiableList(protocols);
    }

    private FileTransferNegotiator(XMPPConnection connection) {
        super(connection);
        this.byteStreamTransferManager = new Socks5TransferNegotiator(connection);
        this.inbandTransferManager = new IBBTransferNegotiator(connection);
        FileTransferNegotiator.setServiceEnabled(connection, true);
    }

    public StreamNegotiator selectStreamNegotiator(FileTransferRequest request) throws XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        StreamNegotiator selectedStreamNegotiator;
        StreamInitiation si = request.getStreamInitiation();
        FormField streamMethodField = this.getStreamMethodField(si.getFeatureNegotiationForm());
        if (streamMethodField == null) {
            String errorMessage = "No stream methods contained in packet.";
            XMPPError error = new XMPPError(XMPPError.Condition.bad_request, errorMessage);
            IQ iqPacket = IQ.createErrorResponse((IQ)si, (XMPPError)error);
            this.connection().sendPacket((Packet)iqPacket);
            throw new XMPPException.XMPPErrorException(errorMessage, error);
        }
        try {
            selectedStreamNegotiator = this.getNegotiator(streamMethodField);
        }
        catch (XMPPException.XMPPErrorException e) {
            IQ iqPacket = IQ.createErrorResponse((IQ)si, (XMPPError)e.getXMPPError());
            this.connection().sendPacket((Packet)iqPacket);
            throw e;
        }
        return selectedStreamNegotiator;
    }

    private FormField getStreamMethodField(DataForm form) {
        for (FormField field : form.getFields()) {
            if (!field.getVariable().equals(STREAM_DATA_FIELD_NAME)) continue;
            return field;
        }
        return null;
    }

    private StreamNegotiator getNegotiator(FormField field) throws XMPPException.XMPPErrorException {
        boolean isByteStream = false;
        boolean isIBB = false;
        for (FormField.Option option : field.getOptions()) {
            String variable = option.getValue();
            if (variable.equals("http://jabber.org/protocol/bytestreams") && !IBB_ONLY) {
                isByteStream = true;
                continue;
            }
            if (!variable.equals("http://jabber.org/protocol/ibb")) continue;
            isIBB = true;
        }
        if (!isByteStream && !isIBB) {
            XMPPError error = new XMPPError(XMPPError.Condition.bad_request, "No acceptable transfer mechanism");
            throw new XMPPException.XMPPErrorException(error);
        }
        if (isByteStream && isIBB) {
            return new FaultTolerantNegotiator(this.connection(), this.byteStreamTransferManager, this.inbandTransferManager);
        }
        if (isByteStream) {
            return this.byteStreamTransferManager;
        }
        return this.inbandTransferManager;
    }

    public String getNextStreamID() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(STREAM_INIT_PREFIX);
        buffer.append(Math.abs(randomGenerator.nextLong()));
        return buffer.toString();
    }

    public StreamNegotiator negotiateOutgoingTransfer(String userID, String streamID, String fileName, long size, String desc, int responseTimeout) throws XMPPException.XMPPErrorException, SmackException.NotConnectedException, SmackException.NoResponseException {
        StreamInitiation si = new StreamInitiation();
        si.setSessionID(streamID);
        si.setMimeType(URLConnection.guessContentTypeFromName(fileName));
        StreamInitiation.File siFile = new StreamInitiation.File(fileName, size);
        siFile.setDesc(desc);
        si.setFile(siFile);
        si.setFeatureNegotiationForm(this.createDefaultInitiationForm());
        si.setFrom(this.connection().getUser());
        si.setTo(userID);
        si.setType(IQ.Type.set);
        Packet siResponse = this.connection().createPacketCollectorAndSend((IQ)si).nextResultOrThrow((long)responseTimeout);
        if (siResponse instanceof IQ) {
            IQ iqResponse = (IQ)siResponse;
            if (iqResponse.getType().equals((Object)IQ.Type.result)) {
                StreamInitiation response = (StreamInitiation)siResponse;
                return this.getOutgoingNegotiator(this.getStreamMethodField(response.getFeatureNegotiationForm()));
            }
            throw new XMPPException.XMPPErrorException(iqResponse.getError());
        }
        return null;
    }

    private StreamNegotiator getOutgoingNegotiator(FormField field) throws XMPPException.XMPPErrorException {
        boolean isByteStream = false;
        boolean isIBB = false;
        for (String variable : field.getValues()) {
            if (variable.equals("http://jabber.org/protocol/bytestreams") && !IBB_ONLY) {
                isByteStream = true;
                continue;
            }
            if (!variable.equals("http://jabber.org/protocol/ibb")) continue;
            isIBB = true;
        }
        if (!isByteStream && !isIBB) {
            XMPPError error = new XMPPError(XMPPError.Condition.bad_request, "No acceptable transfer mechanism");
            throw new XMPPException.XMPPErrorException(error);
        }
        if (isByteStream && isIBB) {
            return new FaultTolerantNegotiator(this.connection(), this.byteStreamTransferManager, this.inbandTransferManager);
        }
        if (isByteStream) {
            return this.byteStreamTransferManager;
        }
        return this.inbandTransferManager;
    }

    private DataForm createDefaultInitiationForm() {
        DataForm form = new DataForm("form");
        FormField field = new FormField(STREAM_DATA_FIELD_NAME);
        field.setType("list-single");
        if (!IBB_ONLY) {
            field.addOption(new FormField.Option("http://jabber.org/protocol/bytestreams"));
        }
        field.addOption(new FormField.Option("http://jabber.org/protocol/ibb"));
        form.addField(field);
        return form;
    }
}

