/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.iqversion.packet;

import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.util.XmlStringBuilder;

public class Version
extends IQ {
    public static final String NAMESPACE = "jabber:iq:version";
    private final String name;
    private final String version;
    private String os;

    public Version() {
        this.name = null;
        this.version = null;
        this.setType(IQ.Type.get);
    }

    public Version(String to) {
        this();
        this.setTo(to);
    }

    public Version(String name, String version) {
        this(name, version, null);
    }

    public Version(String name, String version, String os) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        if (version == null) {
            throw new IllegalArgumentException("version must not be null");
        }
        this.setType(IQ.Type.result);
        this.name = name;
        this.version = version;
        this.os = os;
    }

    public Version(Version original) {
        this(original.name, original.version, original.os);
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getOs() {
        return this.os;
    }

    public void setOs(String os) {
        this.os = os;
    }

    public XmlStringBuilder getChildElementXML() {
        XmlStringBuilder xml = new XmlStringBuilder();
        xml.halfOpenElement("query").xmlnsAttribute(NAMESPACE).rightAngleBracket();
        xml.optElement("name", this.name);
        xml.optElement("version", this.version);
        xml.optElement("os", this.os);
        xml.closeElement("query");
        return xml;
    }

    public static Version createResultFor(Packet request, Version version) {
        Version result = new Version(version);
        result.setPacketID(request.getPacketID());
        result.setTo(request.getFrom());
        return result;
    }
}

