/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.filetransfer;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.OrFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smackx.filetransfer.StreamNegotiator;
import org.jivesoftware.smackx.si.packet.StreamInitiation;

public class FaultTolerantNegotiator
extends StreamNegotiator {
    private final StreamNegotiator primaryNegotiator;
    private final StreamNegotiator secondaryNegotiator;
    private final XMPPConnection connection;
    private PacketFilter primaryFilter;
    private PacketFilter secondaryFilter;

    public FaultTolerantNegotiator(XMPPConnection connection, StreamNegotiator primary, StreamNegotiator secondary) {
        this.primaryNegotiator = primary;
        this.secondaryNegotiator = secondary;
        this.connection = connection;
    }

    @Override
    public PacketFilter getInitiationPacketFilter(String from, String streamID) {
        if (this.primaryFilter == null || this.secondaryFilter == null) {
            this.primaryFilter = this.primaryNegotiator.getInitiationPacketFilter(from, streamID);
            this.secondaryFilter = this.secondaryNegotiator.getInitiationPacketFilter(from, streamID);
        }
        return new OrFilter(new PacketFilter[]{this.primaryFilter, this.secondaryFilter});
    }

    @Override
    InputStream negotiateIncomingStream(Packet streamInitiation) {
        throw new UnsupportedOperationException("Negotiation only handled by create incoming stream method.");
    }

    @Override
    final Packet initiateIncomingStream(XMPPConnection connection, StreamInitiation initiation) {
        throw new UnsupportedOperationException("Initiation handled by createIncomingStream method");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream createIncomingStream(StreamInitiation initiation) throws SmackException {
        PacketCollector collector = this.connection.createPacketCollectorAndSend(this.getInitiationPacketFilter(initiation.getFrom(), initiation.getSessionID()), (Packet)super.createInitiationAccept(initiation, this.getNamespaces()));
        ExecutorService threadPoolExecutor = Executors.newFixedThreadPool(2);
        ExecutorCompletionService<InputStream> service = new ExecutorCompletionService<InputStream>(threadPoolExecutor);
        ArrayList<Future<InputStream>> futures = new ArrayList<Future<InputStream>>();
        InputStream stream = null;
        SmackException exception = null;
        try {
            futures.add(service.submit(new NegotiatorService(collector)));
            futures.add(service.submit(new NegotiatorService(collector)));
            int i = 0;
            while (stream == null && i < futures.size()) {
                Future future;
                try {
                    ++i;
                    future = service.poll(this.connection.getPacketReplyTimeout(), TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    continue;
                }
                if (future == null) continue;
                try {
                    stream = (InputStream)future.get();
                }
                catch (InterruptedException e) {
                }
                catch (ExecutionException e) {
                    exception = new SmackException(e.getCause());
                }
            }
        }
        finally {
            for (Future future : futures) {
                future.cancel(true);
            }
            collector.cancel();
            threadPoolExecutor.shutdownNow();
        }
        if (stream == null) {
            if (exception != null) {
                throw exception;
            }
            throw new SmackException("File transfer negotiation failed.");
        }
        return stream;
    }

    private StreamNegotiator determineNegotiator(Packet streamInitiation) {
        return this.primaryFilter.accept(streamInitiation) ? this.primaryNegotiator : this.secondaryNegotiator;
    }

    @Override
    public OutputStream createOutgoingStream(String streamID, String initiator, String target) throws SmackException, XMPPException {
        OutputStream stream;
        try {
            stream = this.primaryNegotiator.createOutgoingStream(streamID, initiator, target);
        }
        catch (Exception ex) {
            stream = this.secondaryNegotiator.createOutgoingStream(streamID, initiator, target);
        }
        return stream;
    }

    @Override
    public String[] getNamespaces() {
        String[] primary = this.primaryNegotiator.getNamespaces();
        String[] secondary = this.secondaryNegotiator.getNamespaces();
        String[] namespaces = new String[primary.length + secondary.length];
        System.arraycopy(primary, 0, namespaces, 0, primary.length);
        System.arraycopy(secondary, 0, namespaces, primary.length, secondary.length);
        return namespaces;
    }

    private class NegotiatorService
    implements Callable<InputStream> {
        private PacketCollector collector;

        NegotiatorService(PacketCollector collector) {
            this.collector = collector;
        }

        @Override
        public InputStream call() throws XMPPException.XMPPErrorException, InterruptedException, SmackException {
            Packet streamInitiation = this.collector.nextResult();
            if (streamInitiation == null) {
                throw new SmackException.NoResponseException(FaultTolerantNegotiator.this.connection);
            }
            StreamNegotiator negotiator = FaultTolerantNegotiator.this.determineNegotiator(streamInitiation);
            return negotiator.negotiateIncomingStream(streamInitiation);
        }
    }
}

