/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.socks5;

import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;
import org.jivesoftware.smack.AbstractConnectionClosedListener;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.iqrequest.IQRequestHandler;
import org.jivesoftware.smack.packet.ErrorIQ;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smackx.bytestreams.BytestreamListener;
import org.jivesoftware.smackx.bytestreams.BytestreamManager;
import org.jivesoftware.smackx.bytestreams.socks5.InitiationListener;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5BytestreamSession;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5Client;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5ClientForInitiator;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5Proxy;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5Utils;
import org.jivesoftware.smackx.bytestreams.socks5.packet.Bytestream;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.disco.packet.DiscoverItems;

public final class Socks5BytestreamManager
implements BytestreamManager {
    private static final String SESSION_ID_PREFIX = "js5_";
    private static final Random randomGenerator;
    private static final Map<XMPPConnection, Socks5BytestreamManager> managers;
    private final XMPPConnection connection;
    private final Map<String, BytestreamListener> userListeners = new ConcurrentHashMap<String, BytestreamListener>();
    private final List<BytestreamListener> allRequestListeners = Collections.synchronizedList(new LinkedList());
    private final InitiationListener initiationListener;
    private int targetResponseTimeout = 10000;
    private int proxyConnectionTimeout = 10000;
    private final List<String> proxyBlacklist = Collections.synchronizedList(new LinkedList());
    private String lastWorkingProxy = null;
    private boolean proxyPrioritizationEnabled = true;
    private List<String> ignoredBytestreamRequests = Collections.synchronizedList(new LinkedList());

    public static synchronized Socks5BytestreamManager getBytestreamManager(XMPPConnection connection) {
        if (connection == null) {
            return null;
        }
        Socks5BytestreamManager manager = managers.get(connection);
        if (manager == null) {
            manager = new Socks5BytestreamManager(connection);
            managers.put(connection, manager);
            manager.activate();
        }
        return manager;
    }

    private Socks5BytestreamManager(XMPPConnection connection) {
        this.connection = connection;
        this.initiationListener = new InitiationListener(this);
    }

    @Override
    public void addIncomingBytestreamListener(BytestreamListener listener) {
        this.allRequestListeners.add(listener);
    }

    @Override
    public void removeIncomingBytestreamListener(BytestreamListener listener) {
        this.allRequestListeners.remove(listener);
    }

    @Override
    public void addIncomingBytestreamListener(BytestreamListener listener, String initiatorJID) {
        this.userListeners.put(initiatorJID, listener);
    }

    @Override
    public void removeIncomingBytestreamListener(String initiatorJID) {
        this.userListeners.remove(initiatorJID);
    }

    public void ignoreBytestreamRequestOnce(String sessionID) {
        this.ignoredBytestreamRequests.add(sessionID);
    }

    public synchronized void disableService() {
        ServiceDiscoveryManager serviceDiscoveryManager;
        this.connection.unregisterIQRequestHandler((IQRequestHandler)this.initiationListener);
        this.initiationListener.shutdown();
        this.allRequestListeners.clear();
        this.userListeners.clear();
        this.lastWorkingProxy = null;
        this.proxyBlacklist.clear();
        this.ignoredBytestreamRequests.clear();
        managers.remove(this.connection);
        if (managers.size() == 0) {
            Socks5Proxy.getSocks5Proxy().stop();
        }
        if ((serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(this.connection)) != null) {
            serviceDiscoveryManager.removeFeature("http://jabber.org/protocol/bytestreams");
        }
    }

    public int getTargetResponseTimeout() {
        if (this.targetResponseTimeout <= 0) {
            this.targetResponseTimeout = 10000;
        }
        return this.targetResponseTimeout;
    }

    public void setTargetResponseTimeout(int targetResponseTimeout) {
        this.targetResponseTimeout = targetResponseTimeout;
    }

    public int getProxyConnectionTimeout() {
        if (this.proxyConnectionTimeout <= 0) {
            this.proxyConnectionTimeout = 10000;
        }
        return this.proxyConnectionTimeout;
    }

    public void setProxyConnectionTimeout(int proxyConnectionTimeout) {
        this.proxyConnectionTimeout = proxyConnectionTimeout;
    }

    public boolean isProxyPrioritizationEnabled() {
        return this.proxyPrioritizationEnabled;
    }

    public void setProxyPrioritizationEnabled(boolean proxyPrioritizationEnabled) {
        this.proxyPrioritizationEnabled = proxyPrioritizationEnabled;
    }

    @Override
    public Socks5BytestreamSession establishSession(String targetJID) throws XMPPException, IOException, InterruptedException, SmackException {
        String sessionID = this.getNextSessionID();
        return this.establishSession(targetJID, sessionID);
    }

    @Override
    public Socks5BytestreamSession establishSession(String targetJID, String sessionID) throws IOException, InterruptedException, SmackException.NoResponseException, SmackException, XMPPException {
        XMPPException.XMPPErrorException discoveryException = null;
        if (!this.supportsSocks5(targetJID)) {
            throw new SmackException.FeatureNotSupportedException("SOCKS5 Bytestream", targetJID);
        }
        ArrayList<String> proxies = new ArrayList<String>();
        try {
            proxies.addAll(this.determineProxies());
        }
        catch (XMPPException.XMPPErrorException e) {
            discoveryException = e;
        }
        List<Bytestream.StreamHost> streamHosts = this.determineStreamHostInfos(proxies);
        if (streamHosts.isEmpty()) {
            if (discoveryException != null) {
                throw discoveryException;
            }
            throw new SmackException("no SOCKS5 proxies available");
        }
        String digest = Socks5Utils.createDigest(sessionID, this.connection.getUser(), targetJID);
        if (this.proxyPrioritizationEnabled && this.lastWorkingProxy != null) {
            Bytestream.StreamHost selectedStreamHost = null;
            for (Bytestream.StreamHost streamHost : streamHosts) {
                if (!streamHost.getJID().equals(this.lastWorkingProxy)) continue;
                selectedStreamHost = streamHost;
                break;
            }
            if (selectedStreamHost != null) {
                streamHosts.remove(selectedStreamHost);
                streamHosts.add(0, selectedStreamHost);
            }
        }
        Socks5Proxy socks5Proxy = Socks5Proxy.getSocks5Proxy();
        try {
            socks5Proxy.addTransfer(digest);
            Bytestream initiation = this.createBytestreamInitiation(sessionID, targetJID, streamHosts);
            Packet response = this.connection.createPacketCollectorAndSend((IQ)initiation).nextResultOrThrow((long)this.getTargetResponseTimeout());
            Bytestream.StreamHostUsed streamHostUsed = ((Bytestream)response).getUsedHost();
            Bytestream.StreamHost usedStreamHost = initiation.getStreamHost(streamHostUsed.getJID());
            if (usedStreamHost == null) {
                throw new SmackException("Remote user responded with unknown host");
            }
            Socks5ClientForInitiator socks5Client = new Socks5ClientForInitiator(usedStreamHost, digest, this.connection, sessionID, targetJID);
            Socket socket = ((Socks5Client)socks5Client).getSocket(this.getProxyConnectionTimeout());
            this.lastWorkingProxy = usedStreamHost.getJID();
            Socks5BytestreamSession socks5BytestreamSession = new Socks5BytestreamSession(socket, usedStreamHost.getJID().equals(this.connection.getUser()));
            return socks5BytestreamSession;
        }
        catch (TimeoutException e) {
            throw new IOException("Timeout while connecting to SOCKS5 proxy");
        }
        finally {
            socks5Proxy.removeTransfer(digest);
        }
    }

    private boolean supportsSocks5(String targetJID) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        return ServiceDiscoveryManager.getInstanceFor(this.connection).supportsFeature(targetJID, "http://jabber.org/protocol/bytestreams");
    }

    private List<String> determineProxies() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        ServiceDiscoveryManager serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(this.connection);
        ArrayList<String> proxies = new ArrayList<String>();
        DiscoverItems discoverItems = serviceDiscoveryManager.discoverItems(this.connection.getServiceName());
        for (DiscoverItems.Item item : discoverItems.getItems()) {
            DiscoverInfo proxyInfo;
            if (this.proxyBlacklist.contains(item.getEntityID())) continue;
            try {
                proxyInfo = serviceDiscoveryManager.discoverInfo(item.getEntityID());
            }
            catch (SmackException.NoResponseException | XMPPException.XMPPErrorException e) {
                this.proxyBlacklist.add(item.getEntityID());
                continue;
            }
            if (proxyInfo.hasIdentity("proxy", "bytestreams")) {
                proxies.add(item.getEntityID());
                continue;
            }
            this.proxyBlacklist.add(item.getEntityID());
        }
        return proxies;
    }

    private List<Bytestream.StreamHost> determineStreamHostInfos(List<String> proxies) {
        ArrayList<Bytestream.StreamHost> streamHosts = new ArrayList<Bytestream.StreamHost>();
        List<Bytestream.StreamHost> localProxies = this.getLocalStreamHost();
        if (localProxies != null) {
            streamHosts.addAll(localProxies);
        }
        for (String proxy : proxies) {
            Bytestream streamHostRequest = this.createStreamHostRequest(proxy);
            try {
                Bytestream response = (Bytestream)this.connection.createPacketCollectorAndSend((IQ)streamHostRequest).nextResultOrThrow();
                streamHosts.addAll(response.getStreamHosts());
            }
            catch (Exception e) {
                this.proxyBlacklist.add(proxy);
            }
        }
        return streamHosts;
    }

    private Bytestream createStreamHostRequest(String proxy) {
        Bytestream request = new Bytestream();
        request.setType(IQ.Type.get);
        request.setTo(proxy);
        return request;
    }

    private List<Bytestream.StreamHost> getLocalStreamHost() {
        Socks5Proxy socks5Server = Socks5Proxy.getSocks5Proxy();
        if (!socks5Server.isRunning()) {
            return null;
        }
        List<String> addresses = socks5Server.getLocalAddresses();
        if (addresses.isEmpty()) {
            return null;
        }
        int port = socks5Server.getPort();
        ArrayList<Bytestream.StreamHost> streamHosts = new ArrayList<Bytestream.StreamHost>();
        block0: for (String address : addresses) {
            String[] loopbackAddresses;
            for (String loopbackAddress : loopbackAddresses = new String[]{"127.0.0.1", "0:0:0:0:0:0:0:1", "::1"}) {
                if (address.startsWith(loopbackAddress)) continue block0;
            }
            streamHosts.add(new Bytestream.StreamHost(this.connection.getUser(), address, port));
        }
        return streamHosts;
    }

    private Bytestream createBytestreamInitiation(String sessionID, String targetJID, List<Bytestream.StreamHost> streamHosts) {
        Bytestream initiation = new Bytestream(sessionID);
        for (Bytestream.StreamHost streamHost : streamHosts) {
            initiation.addStreamHost(streamHost);
        }
        initiation.setType(IQ.Type.set);
        initiation.setTo(targetJID);
        return initiation;
    }

    protected void replyRejectPacket(IQ packet) throws SmackException.NotConnectedException {
        XMPPError xmppError = new XMPPError(XMPPError.Condition.not_acceptable);
        ErrorIQ errorIQ = IQ.createErrorResponse((IQ)packet, (XMPPError)xmppError);
        this.connection.sendPacket((Packet)errorIQ);
    }

    private void activate() {
        this.connection.registerIQRequestHandler((IQRequestHandler)this.initiationListener);
        this.enableService();
    }

    private void enableService() {
        ServiceDiscoveryManager manager = ServiceDiscoveryManager.getInstanceFor(this.connection);
        manager.addFeature("http://jabber.org/protocol/bytestreams");
    }

    private String getNextSessionID() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(SESSION_ID_PREFIX);
        buffer.append(Math.abs(randomGenerator.nextLong()));
        return buffer.toString();
    }

    protected XMPPConnection getConnection() {
        return this.connection;
    }

    protected BytestreamListener getUserListener(String initiator) {
        return this.userListeners.get(initiator);
    }

    protected List<BytestreamListener> getAllRequestListeners() {
        return this.allRequestListeners;
    }

    protected List<String> getIgnoredBytestreamRequests() {
        return this.ignoredBytestreamRequests;
    }

    static {
        XMPPConnectionRegistry.addConnectionCreationListener((ConnectionCreationListener)new ConnectionCreationListener(){

            public void connectionCreated(final XMPPConnection connection) {
                Socks5BytestreamManager.getBytestreamManager(connection);
                connection.addConnectionListener((ConnectionListener)new AbstractConnectionClosedListener(){

                    public void connectionTerminated() {
                        Socks5BytestreamManager.getBytestreamManager(connection).disableService();
                    }

                    public void reconnectionSuccessful() {
                        Socks5BytestreamManager.getBytestreamManager(connection);
                    }
                });
            }
        });
        randomGenerator = new Random();
        managers = new HashMap<XMPPConnection, Socks5BytestreamManager>();
    }
}

